/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.direct;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.direct.DirectCallHttpServer;
import com.github.tomakehurst.wiremock.direct.DirectCallHttpServerFactory;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DirectCallHttpServerIntegrationTest {
    DirectCallHttpServerIntegrationTest() {
    }

    @Test
    void exampleUsage() {
        DirectCallHttpServerFactory factory = new DirectCallHttpServerFactory();
        WireMockServer wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().httpServerFactory((HttpServerFactory)factory));
        wm.start();
        DirectCallHttpServer server = factory.getHttpServer();
        Response response = server.stubRequest((Request)MockRequest.mockRequest());
        Assertions.assertEquals((int)404, (int)response.getStatus());
    }

    @Test
    void withDelay() {
        DirectCallHttpServerFactory factory = new DirectCallHttpServerFactory();
        WireMockServer wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().usingFilesUnderClasspath("classpath-filesource").httpServerFactory((HttpServerFactory)factory));
        wm.start();
        DirectCallHttpServer server = factory.getHttpServer();
        MockRequest mockRequest = MockRequest.mockRequest().url("/slow-response").method(RequestMethod.GET);
        Stopwatch stopwatch = Stopwatch.createStarted();
        Response response = server.stubRequest((Request)mockRequest);
        stopwatch.stop();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        MatcherAssert.assertThat((Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(499L)));
    }

    @Test
    void withFileBody() {
        DirectCallHttpServerFactory factory = new DirectCallHttpServerFactory();
        WireMockServer wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().usingFilesUnderClasspath("classpath-filesource").httpServerFactory((HttpServerFactory)factory));
        wm.start();
        DirectCallHttpServer server = factory.getHttpServer();
        MockRequest mockRequest = MockRequest.mockRequest().url("/test").method(RequestMethod.GET);
        Response response = server.stubRequest((Request)mockRequest);
        Assertions.assertEquals((Object)"THINGS!", (Object)response.getBodyAsString());
    }
}

