/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelperTestBase;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.TruncateDateTimeHelper;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TruncateDateTimeHelperTest
extends HandlebarsHelperTestBase {
    private TruncateDateTimeHelper helper;

    @BeforeEach
    public void init() {
        this.helper = new TruncateDateTimeHelper();
    }

    @Test
    public void truncatesDateObject() throws IOException {
        Date date = Date.from(ZonedDateTime.parse("2020-03-27T11:22:33Z").toInstant());
        Object output = this.renderHelperValue(this.helper, date, new Object[]{"last day of month"});
        MatcherAssert.assertThat(output, (Matcher)Matchers.instanceOf(Date.class));
        Date truncated = (Date)output;
        MatcherAssert.assertThat((Object)truncated.toInstant(), (Matcher)Matchers.is((Object)Instant.parse("2020-03-31T00:00:00Z")));
    }
}

