/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.Body;
import java.util.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BodyTest {
    BodyTest() {
    }

    @Test
    void constructsFromBytes() {
        Body body = Body.fromOneOf((byte[])"this content".getBytes(), (String)"not this content", (JsonNode)new IntNode(1), (String)"lskdjflsjdflks");
        MatcherAssert.assertThat((Object)body.asString(), (Matcher)Matchers.is((Object)"this content"));
        MatcherAssert.assertThat((Object)body.isBinary(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)body.isJson(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void constructsFromString() {
        Body body = Body.fromOneOf(null, (String)"this content", (JsonNode)new IntNode(1), (String)"lskdjflsjdflks");
        MatcherAssert.assertThat((Object)body.asString(), (Matcher)Matchers.is((Object)"this content"));
        MatcherAssert.assertThat((Object)body.isBinary(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)body.isJson(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void constructsFromJson() {
        Body body = Body.fromOneOf(null, null, (JsonNode)new IntNode(1), (String)"lskdjflsjdflks");
        MatcherAssert.assertThat((Object)body.asString(), (Matcher)Matchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)body.isBinary(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)body.isJson(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void constructsFromBase64() {
        byte[] base64Encoded = Base64.getEncoder().encodeToString("this content".getBytes()).getBytes();
        String encodedText = Strings.stringFromBytes((byte[])base64Encoded);
        Body body = Body.fromOneOf(null, null, null, (String)encodedText);
        MatcherAssert.assertThat((Object)body.asString(), (Matcher)Matchers.is((Object)"this content"));
        MatcherAssert.assertThat((Object)body.isBinary(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)body.isJson(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void bodyAsJson() {
        JsonNode jsonContent = Json.node((String)"{\"name\":\"wiremock\",\"isCool\":true}");
        Body body = Body.fromOneOf(null, null, (JsonNode)jsonContent, (String)"lskdjflsjdflks");
        MatcherAssert.assertThat((Object)body.asJson(), (Matcher)Matchers.is((Object)jsonContent));
    }

    @Test
    void hashCorrectly() {
        byte[] primes = new byte[]{2, 3, 5, 7};
        byte[] primes2 = new byte[]{2, 3, 5, 7};
        Body body = new Body(primes);
        Body body2 = new Body(primes2);
        Assertions.assertEquals((int)body.hashCode(), (int)body2.hashCode());
    }
}

