/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class HttpHeadersTest {
    private static final String SINGLE_VALUE_HEADER = "{                \t    \t    \t\t        \n\t\"Header-1\": \"only-value\"                \n}                                               ";
    private static final String MULTI_VALUE_HEADER = "{    \t                         \t    \t\t        \n\t\t    \"Header-1\": [                             \n\t\t        \"value-1\",                            \n               \"value-2\"                             \n           ],                                          \n\t\t    \"Header-2\": [                             \n\t\t        \"value-3\",                            \n               \"value-4\"                             \n           ]                                           \n}                                                        ";

    @Test
    public void returnsAbsentHttpHeaderWhenHeaderNotPresent() {
        HttpHeaders httpHeaders = new HttpHeaders();
        HttpHeader header = httpHeaders.getHeader("Test-Header");
        MatcherAssert.assertThat((Object)header.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void returnsHeaderWhenPresent() {
        HttpHeaders httpHeaders = new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Test-Header", (String[])new String[]{"value1", "value2"})});
        HttpHeader header = httpHeaders.getHeader("Test-Header");
        MatcherAssert.assertThat((Object)header.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)header.key(), (Matcher)Matchers.is((Object)"Test-Header"));
        MatcherAssert.assertThat((Object)header.containsValue("value2"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void createsCopy() {
        HttpHeaders httpHeaders = new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Header-1", (String[])new String[]{"h1v1", "h1v2"}), HttpHeader.httpHeader((String)"Header-2", (String[])new String[]{"h2v1", "h2v2"})});
        HttpHeaders copyOfHeaders = HttpHeaders.copyOf((HttpHeaders)httpHeaders);
        MatcherAssert.assertThat((Object)copyOfHeaders.all(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{WireMatchers.header("Header-1", "h1v1"), WireMatchers.header("Header-1", "h1v2"), WireMatchers.header("Header-2", "h2v1"), WireMatchers.header("Header-2", "h2v2")}));
    }

    @Test
    public void correctlyDeserializesWithSingleValueHeader() {
        HttpHeaders headers = (HttpHeaders)Json.read((String)SINGLE_VALUE_HEADER, HttpHeaders.class);
        HttpHeader header = headers.getHeader("Header-1");
        MatcherAssert.assertThat((Object)header.key(), (Matcher)Matchers.is((Object)"Header-1"));
        MatcherAssert.assertThat((Object)header.firstValue(), (Matcher)Matchers.is((Object)"only-value"));
        MatcherAssert.assertThat((Object)header.values().size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void correctlySerializesSingleValueHeader() {
        HttpHeaders headers = new HttpHeaders(new HttpHeader[]{new HttpHeader("Header-1", new String[]{"only-value"})});
        String json = Json.write((Object)headers);
        MatcherAssert.assertThat((String)("Actual: " + json), (Object)json, WireMatchers.equalToJson(SINGLE_VALUE_HEADER));
    }

    @Test
    public void correctlyDeserializesWithMultiValueHeader() {
        HttpHeaders headers = (HttpHeaders)Json.read((String)MULTI_VALUE_HEADER, HttpHeaders.class);
        HttpHeader header = headers.getHeader("Header-1");
        MatcherAssert.assertThat((Object)header.key(), (Matcher)Matchers.is((Object)"Header-1"));
        MatcherAssert.assertThat((Object)header.values(), WireMatchers.hasExactly(Matchers.equalTo((Object)"value-1"), Matchers.equalTo((Object)"value-2")));
        MatcherAssert.assertThat((Object)header.values().size(), (Matcher)Matchers.is((Object)2));
        header = headers.getHeader("Header-2");
        MatcherAssert.assertThat((Object)header.key(), (Matcher)Matchers.is((Object)"Header-2"));
        MatcherAssert.assertThat((Object)header.values(), WireMatchers.hasExactly(Matchers.equalTo((Object)"value-3"), Matchers.equalTo((Object)"value-4")));
        MatcherAssert.assertThat((Object)header.values().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)headers.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void correctlySerializesMultiValueHeader() {
        HttpHeaders headers = new HttpHeaders(new HttpHeader[]{new HttpHeader("Header-1", new String[]{"value-1", "value-2"}), new HttpHeader("Header-2", new String[]{"value-3", "value-4"})});
        String json = Json.write((Object)headers);
        MatcherAssert.assertThat((String)("Actual: " + json), (Object)json, WireMatchers.equalToJson(MULTI_VALUE_HEADER));
    }

    @Test
    public void keyMatchingIsCaseInsensitive() {
        HttpHeaders headers = new HttpHeaders(new HttpHeader[]{new HttpHeader("Header-One", new String[]{"value 1"})});
        MatcherAssert.assertThat((Object)headers.getHeader("header-one").firstValue(), (Matcher)Matchers.is((Object)"value 1"));
    }

    @Test
    public void toStringWhenHeadersPresent() {
        HttpHeaders httpHeaders = new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Test-Header", (String[])new String[]{"value1", "value2"})});
        MatcherAssert.assertThat((Object)httpHeaders.toString().contains("Test-Header"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void toStringWhenHeadersEmpty() {
        HttpHeaders httpHeaders = new HttpHeaders();
        MatcherAssert.assertThat((Object)httpHeaders.toString().equals("(no headers)\n"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldEqualWhenIdentical() throws Exception {
        HttpHeaders httpHeaders = new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Header-1", (String[])new String[]{"h1v1", "h1v2"}), HttpHeader.httpHeader((String)"Header-2", (String[])new String[]{"h2v1", "h2v2"})});
        HttpHeaders copyOfHeaders = HttpHeaders.copyOf((HttpHeaders)httpHeaders);
        MatcherAssert.assertThat((Object)httpHeaders.equals((Object)copyOfHeaders), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)httpHeaders.hashCode(), (Matcher)Matchers.equalTo((Object)copyOfHeaders.hashCode()));
    }
}

