/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.http.ssl.ApacheHttpHostNameMatcher;
import com.github.tomakehurst.wiremock.http.ssl.CertificateGeneratingX509ExtendedKeyManager;
import com.github.tomakehurst.wiremock.http.ssl.DynamicKeyStore;
import com.github.tomakehurst.wiremock.http.ssl.HostNameMatcher;
import com.github.tomakehurst.wiremock.testsupport.TestNotifier;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class CertificateGeneratingX509ExtendedKeyManagerChooseEngineServerAliasDefaultsTest {
    private final X509ExtendedKeyManager keyManagerMock = (X509ExtendedKeyManager)Mockito.mock(X509ExtendedKeyManager.class);
    private final SSLEngine sslEngineMock = (SSLEngine)Mockito.mock(SSLEngine.class);
    private final SSLEngine nullSslEngine = null;
    private final SSLSession nonExtendedSslSessionMock = (SSLSession)Mockito.mock(SSLSession.class);
    private final ExtendedSSLSession extendedSslSessionMock = (ExtendedSSLSession)Mockito.mock(ExtendedSSLSession.class);
    private final TestNotifier testNotifier = new TestNotifier();
    private final CertificateGeneratingX509ExtendedKeyManager certificateGeneratingKeyManager = new CertificateGeneratingX509ExtendedKeyManager(this.keyManagerMock, (DynamicKeyStore)Mockito.mock(DynamicKeyStore.class), (HostNameMatcher)new ApacheHttpHostNameMatcher(), (Notifier)this.testNotifier);
    private final Principal[] nullPrincipals = null;

    @Test
    public void returnsNullIfDefaultAliasReturnsNull() {
        BDDMockito.given((Object)this.keyManagerMock.chooseEngineServerAlias("RSA", this.nullPrincipals, this.sslEngineMock)).willReturn(null);
        String alias = this.certificateGeneratingKeyManager.chooseEngineServerAlias("RSA", this.nullPrincipals, this.sslEngineMock);
        Assertions.assertNull((Object)alias);
    }

    @Test
    public void returnsDefaultIfEngineIsNull() {
        BDDMockito.given((Object)this.keyManagerMock.chooseEngineServerAlias("RSA", this.nullPrincipals, this.nullSslEngine)).willReturn((Object)"default_alias");
        String alias = this.certificateGeneratingKeyManager.chooseEngineServerAlias("RSA", this.nullPrincipals, this.nullSslEngine);
        Assertions.assertEquals((Object)"default_alias", (Object)alias);
    }

    @Test
    public void returnsDefaultIfHandshakeSessionIsNotSupported() {
        BDDMockito.given((Object)this.sslEngineMock.getHandshakeSession()).willThrow(new Throwable[]{new UnsupportedOperationException()});
        String alias = this.certificateGeneratingKeyManager.chooseEngineServerAlias("RSA", this.nullPrincipals, this.sslEngineMock);
        Assertions.assertEquals((Object)"default_alias", (Object)alias);
        MatcherAssert.assertThat(this.testNotifier.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Dynamic certificate generation is not supported because your SSL Provider does not support SSLEngine.getHandshakeSession()" + System.lineSeparator() + "All sites will be served using the normal WireMock HTTPS certificate."}));
    }

    @Test
    public void returnsDefaultIfHandshakeSessionIsNotAnAnExtendedSSLSession() {
        BDDMockito.given((Object)this.sslEngineMock.getHandshakeSession()).willReturn((Object)this.nonExtendedSslSessionMock);
        String alias = this.certificateGeneratingKeyManager.chooseEngineServerAlias("RSA", this.nullPrincipals, this.sslEngineMock);
        Assertions.assertEquals((Object)"default_alias", (Object)alias);
    }

    @Test
    public void returnsDefaultIfGetRequestedServerNamesIsNotSupported() {
        BDDMockito.given(this.extendedSslSessionMock.getRequestedServerNames()).willThrow(new Throwable[]{new UnsupportedOperationException()});
        String alias = this.certificateGeneratingKeyManager.chooseEngineServerAlias("RSA", this.nullPrincipals, this.sslEngineMock);
        Assertions.assertEquals((Object)"default_alias", (Object)alias);
        MatcherAssert.assertThat(this.testNotifier.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"Dynamic certificate generation is not supported because your SSL Provider does not support ExtendedSSLSession.getRequestedServerNames()" + System.lineSeparator() + "All sites will be served using the normal WireMock HTTPS certificate."}));
    }

    @Test
    public void returnsDefaultIfThereAreNoSNIServerNames() {
        BDDMockito.given(this.extendedSslSessionMock.getRequestedServerNames()).willReturn(Collections.emptyList());
        String alias = this.certificateGeneratingKeyManager.chooseEngineServerAlias("RSA", this.nullPrincipals, this.sslEngineMock);
        Assertions.assertEquals((Object)"default_alias", (Object)alias);
    }

    @Test
    public void returnsDefaultIfThereAreNoSNIHostNames() {
        SNIServerName notAnSIHostName = new SNIServerName(1, new byte[0]){};
        BDDMockito.given(this.extendedSslSessionMock.getRequestedServerNames()).willReturn(Collections.singletonList(notAnSIHostName));
        String alias = this.certificateGeneratingKeyManager.chooseEngineServerAlias("RSA", this.nullPrincipals, this.sslEngineMock);
        Assertions.assertEquals((Object)"default_alias", (Object)alias);
    }

    @Test
    public void returnsDefaultIfAnSNIHostNameMatchesTheDefaultCertificate() {
        SNIHostName hostName1 = new SNIHostName("example.com");
        SNIHostName hostName2 = new SNIHostName("wiremock.org");
        SNIHostName hostName3 = new SNIHostName("example.org");
        BDDMockito.given(this.extendedSslSessionMock.getRequestedServerNames()).willReturn(Arrays.asList(hostName1, hostName2, hostName3));
        X509Certificate matchingCertificate = this.certificateWithCn("CN=wiremock.org");
        BDDMockito.given((Object)this.keyManagerMock.getCertificateChain("default_alias")).willReturn((Object)new X509Certificate[]{matchingCertificate});
        String alias = this.certificateGeneratingKeyManager.chooseEngineServerAlias("RSA", this.nullPrincipals, this.sslEngineMock);
        Assertions.assertEquals((Object)"default_alias", (Object)alias);
    }

    private X509Certificate certificateWithCn(String cn) {
        X509Certificate certificate = (X509Certificate)Mockito.mock(X509Certificate.class);
        Mockito.when((Object)certificate.getSubjectX500Principal()).thenReturn((Object)new X500Principal(cn));
        return certificate;
    }

    public CertificateGeneratingX509ExtendedKeyManagerChooseEngineServerAliasDefaultsTest() throws Exception {
        Mockito.when((Object)this.keyManagerMock.chooseEngineServerAlias("RSA", this.nullPrincipals, this.sslEngineMock)).thenReturn((Object)"default_alias");
        Mockito.when((Object)this.sslEngineMock.getHandshakeSession()).thenReturn((Object)this.extendedSslSessionMock);
    }
}

