/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.http.ssl.ApacheHttpHostNameMatcher;
import com.github.tomakehurst.wiremock.http.ssl.CertificateGeneratingX509ExtendedKeyManager;
import com.github.tomakehurst.wiremock.http.ssl.DynamicKeyStore;
import com.github.tomakehurst.wiremock.http.ssl.HostNameMatcher;
import com.github.tomakehurst.wiremock.http.ssl.X509KeyStore;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestNotifier;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledForJreRange;
import org.junit.jupiter.api.condition.JRE;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class CertificateGeneratingX509ExtendedKeyManagerChooseEngineServerAliasTest {
    @Test
    @DisabledForJreRange(min=JRE.JAVA_17, disabledReason="does not support generating certificates at runtime")
    public void generatesAndReturnsNewAliasForWorkingPrivateKey() throws Exception {
        KeyStore keyStore = CertificateGeneratingX509ExtendedKeyManagerChooseEngineServerAliasTest.readKeyStore(TestFiles.KEY_STORE_WITH_CA_PATH, "password");
        String hostname = "example.com";
        CertificateGeneratingX509ExtendedKeyManager generatingKeyManager = this.keyManagerFor(keyStore, "password".toCharArray());
        Assertions.assertNull((Object)generatingKeyManager.getCertificateChain(hostname));
        Assertions.assertNull((Object)generatingKeyManager.getPrivateKey(hostname));
        SSLEngine sslEngineMock = this.getSslEngineWithSessionFor(hostname);
        String keyAlias = generatingKeyManager.chooseEngineServerAlias("RSA", null, sslEngineMock);
        Assertions.assertEquals((Object)hostname, (Object)keyAlias);
        Assertions.assertEquals((int)2, (int)generatingKeyManager.getCertificateChain(keyAlias).length);
        RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)generatingKeyManager.getPrivateKey(keyAlias);
        PublicKey myPublicKey = this.getPublicKey(privateKey);
        Assertions.assertEquals((Object)myPublicKey, (Object)generatingKeyManager.getCertificateChain(keyAlias)[0].getPublicKey());
    }

    @Test
    public void returnsSameGeneratedPrivateKeyOnSubsequentCalls() throws Exception {
        KeyStore keyStore = CertificateGeneratingX509ExtendedKeyManagerChooseEngineServerAliasTest.readKeyStore(TestFiles.KEY_STORE_WITH_CA_PATH, "password");
        String hostname = "example.com";
        CertificateGeneratingX509ExtendedKeyManager generatingKeyManager = this.keyManagerFor(keyStore, "password".toCharArray());
        SSLEngine sslEngineMock = this.getSslEngineWithSessionFor(hostname);
        String keyAlias = generatingKeyManager.chooseEngineServerAlias("RSA", null, sslEngineMock);
        Object[] certificateChain = generatingKeyManager.getCertificateChain(keyAlias);
        PrivateKey privateKey = generatingKeyManager.getPrivateKey(keyAlias);
        String sameKeyAlias = generatingKeyManager.chooseEngineServerAlias("RSA", null, sslEngineMock);
        Assertions.assertEquals((Object)keyAlias, (Object)sameKeyAlias);
        Assertions.assertEquals((Object)privateKey, (Object)generatingKeyManager.getPrivateKey(sameKeyAlias));
        Assertions.assertArrayEquals((Object[])certificateChain, (Object[])generatingKeyManager.getCertificateChain(sameKeyAlias));
    }

    private PublicKey getPublicKey(RSAPrivateCrtKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privateKey.getModulus(), privateKey.getPublicExponent());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(publicKeySpec);
    }

    private SSLEngine getSslEngineWithSessionFor(String hostname) {
        SSLEngine sslEngineMock = (SSLEngine)Mockito.mock(SSLEngine.class);
        ExtendedSSLSession extendedSslSessionMock = (ExtendedSSLSession)Mockito.mock(ExtendedSSLSession.class);
        BDDMockito.given((Object)sslEngineMock.getHandshakeSession()).willReturn((Object)extendedSslSessionMock);
        SNIHostName hostName = new SNIHostName(hostname);
        BDDMockito.given(extendedSslSessionMock.getRequestedServerNames()).willReturn(Collections.singletonList(hostName));
        return sslEngineMock;
    }

    private CertificateGeneratingX509ExtendedKeyManager keyManagerFor(KeyStore keyStore, char[] keyStorePassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        X509ExtendedKeyManager keyManager = this.findExtendedKeyManager(keyManagerFactory.getKeyManagers());
        X509KeyStore x509KeyStore = new X509KeyStore(keyStore, keyStorePassword);
        return new CertificateGeneratingX509ExtendedKeyManager(keyManager, new DynamicKeyStore(x509KeyStore), (HostNameMatcher)new ApacheHttpHostNameMatcher(), (Notifier)new TestNotifier());
    }

    private X509ExtendedKeyManager findExtendedKeyManager(KeyManager[] keyManagers) {
        for (KeyManager manager : keyManagers) {
            if (!(manager instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)manager;
        }
        throw new AssertionError((Object)"Can't run this test of the SSL provider does not create X509ExtendedKeyManager instances");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore readKeyStore(String path, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream instream = new FileInputStream(path);){
            trustStore.load(instream, password.toCharArray());
        }
        return trustStore;
    }
}

