/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import com.github.tomakehurst.wiremock.http.ssl.CompositeTrustManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.X509ExtendedTrustManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class CompositeTrustManagerTest {
    private final X509ExtendedTrustManager trustManager1 = this.mockX509ExtendedTrustManager();
    private final X509ExtendedTrustManager trustManager2 = this.mockX509ExtendedTrustManager();
    private final X509Certificate[] chain = new X509Certificate[0];
    private final String authType = "AN_AUTH_TYPE";

    @Test
    public void checkServerTrustedPassesForSingleTrustManager() throws CertificateException {
        CompositeTrustManager compositeTrustManager = new CompositeTrustManager(Collections.singletonList(this.trustManager1));
        compositeTrustManager.checkServerTrusted(this.chain, "AN_AUTH_TYPE");
    }

    @Test
    public void checkServerTrustedFailsForSingleTrustManager() throws CertificateException {
        CertificateException invalidCertForTrustManager1 = new CertificateException("Invalid cert for trustManager1");
        ((X509ExtendedTrustManager)BDDMockito.willThrow((Throwable[])new Throwable[]{invalidCertForTrustManager1}).given((Object)this.trustManager1)).checkServerTrusted(this.chain, "AN_AUTH_TYPE");
        CompositeTrustManager compositeTrustManager = new CompositeTrustManager(Collections.singletonList(this.trustManager1));
        CertificateException thrown = (CertificateException)Assertions.assertThrows(CertificateException.class, () -> compositeTrustManager.checkServerTrusted(this.chain, "AN_AUTH_TYPE"));
        Assertions.assertEquals((Object)invalidCertForTrustManager1, (Object)thrown);
    }

    @Test
    public void checkServerTrustedIfBothWouldPass() throws CertificateException {
        CompositeTrustManager compositeTrustManager = new CompositeTrustManager(Arrays.asList(this.trustManager1, this.trustManager2));
        compositeTrustManager.checkServerTrusted(this.chain, "AN_AUTH_TYPE");
    }

    @Test
    public void checkServerTrustedIfFirstWouldPass() throws CertificateException {
        ((X509ExtendedTrustManager)BDDMockito.willThrow((Throwable[])new Throwable[]{new CertificateException("Invalid cert for trustManager2")}).given((Object)this.trustManager2)).checkServerTrusted(this.chain, "AN_AUTH_TYPE");
        CompositeTrustManager compositeTrustManager = new CompositeTrustManager(Arrays.asList(this.trustManager1, this.trustManager2));
        compositeTrustManager.checkServerTrusted(this.chain, "AN_AUTH_TYPE");
    }

    @Test
    public void checkServerTrustedIfSecondWouldPass() throws CertificateException {
        ((X509ExtendedTrustManager)BDDMockito.willThrow((Throwable[])new Throwable[]{new CertificateException("Invalid cert for trustManager1")}).given((Object)this.trustManager1)).checkServerTrusted(this.chain, "AN_AUTH_TYPE");
        CompositeTrustManager compositeTrustManager = new CompositeTrustManager(Arrays.asList(this.trustManager1, this.trustManager2));
        compositeTrustManager.checkServerTrusted(this.chain, "AN_AUTH_TYPE");
    }

    @Test
    public void checkServerNotTrustedIfNeitherPass() throws CertificateException {
        CertificateException invalidCertForTrustManager2 = new CertificateException("Invalid cert for trustManager2");
        ((X509ExtendedTrustManager)BDDMockito.willThrow((Throwable[])new Throwable[]{new CertificateException("Invalid cert for trustManager1")}).given((Object)this.trustManager1)).checkServerTrusted(this.chain, "AN_AUTH_TYPE");
        ((X509ExtendedTrustManager)BDDMockito.willThrow((Throwable[])new Throwable[]{invalidCertForTrustManager2}).given((Object)this.trustManager2)).checkServerTrusted(this.chain, "AN_AUTH_TYPE");
        CompositeTrustManager compositeTrustManager = new CompositeTrustManager(Arrays.asList(this.trustManager1, this.trustManager2));
        CertificateException thrown = (CertificateException)Assertions.assertThrows(CertificateException.class, () -> compositeTrustManager.checkServerTrusted(this.chain, "AN_AUTH_TYPE"));
        Assertions.assertEquals((Object)invalidCertForTrustManager2, (Object)thrown);
    }

    @Test
    public void returnAllAcceptedIssuers() {
        X509Certificate cert1 = (X509Certificate)Mockito.mock(X509Certificate.class, (String)"cert1");
        X509Certificate cert2 = (X509Certificate)Mockito.mock(X509Certificate.class, (String)"cert2");
        X509Certificate cert3 = (X509Certificate)Mockito.mock(X509Certificate.class, (String)"cert3");
        X509Certificate cert4 = (X509Certificate)Mockito.mock(X509Certificate.class, (String)"cert4");
        BDDMockito.given((Object)this.trustManager1.getAcceptedIssuers()).willReturn((Object)new X509Certificate[]{cert1, cert2});
        BDDMockito.given((Object)this.trustManager2.getAcceptedIssuers()).willReturn((Object)new X509Certificate[]{cert3, cert4});
        CompositeTrustManager compositeTrustManager = new CompositeTrustManager(Arrays.asList(this.trustManager1, this.trustManager2));
        Object[] acceptedIssuers = compositeTrustManager.getAcceptedIssuers();
        Assertions.assertArrayEquals((Object[])new X509Certificate[]{cert1, cert2, cert3, cert4}, (Object[])acceptedIssuers);
        acceptedIssuers[2] = (X509Certificate)Mockito.mock(X509Certificate.class, (String)"cert5");
        Assertions.assertArrayEquals((Object[])new X509Certificate[]{cert1, cert2, cert3, cert4}, (Object[])compositeTrustManager.getAcceptedIssuers());
    }

    private X509ExtendedTrustManager mockX509ExtendedTrustManager() {
        X509ExtendedTrustManager trustManager = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
        Mockito.when((Object)trustManager.getAcceptedIssuers()).thenReturn((Object)new X509Certificate[0]);
        return trustManager;
    }
}

