/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit;

import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class WireMockRuleFailOnUnmatchedRequestsTest {
    public ExpectedException expectedException = ExpectedException.none();
    public WireMockRule wm = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().withRootDirectory("src/main/resources/empty"), true);
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)this.expectedException).around((TestRule)this.wm);
    WireMockTestClient client;

    @Before
    public void init() {
        this.client = new WireMockTestClient(this.wm.port());
    }

    @Test
    public void singleUnmatchedRequestShouldThrowVerificationException() {
        this.expectedException.expect(VerificationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"A request was unmatched by any stub mapping"));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/hit")).willReturn(WireMock.aResponse().withStatus(200)));
        this.client.get("/near-misssss", new TestHttpHeader[0]);
    }

    @Test
    public void manyUnmatchedRequestsShouldThrowVerificationException() {
        this.expectedException.expect(VerificationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"3 requests were unmatched by any stub mapping"));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/hit")).willReturn(WireMock.aResponse().withStatus(200)));
        this.client.get("/near-misssss", new TestHttpHeader[0]);
        this.client.get("/hat", new TestHttpHeader[0]);
        this.client.get("/whatevs", new TestHttpHeader[0]);
    }

    @Test
    public void unmatchedRequestButMatchedStubShouldThrowVerificationException() {
        this.expectedException.expect(VerificationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"A request was unmatched by any stub mapping"));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/hit")).willReturn(WireMock.aResponse().withStatus(200)));
        this.client.get("/near-misssss", new TestHttpHeader[0]);
        this.client.get("/hit", new TestHttpHeader[0]);
    }

    @Test
    public void matchedRequestButUnmatchedStubShouldNotThrowVerificationException() {
        this.expectedException = ExpectedException.none();
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/hit")).willReturn(WireMock.aResponse().withStatus(200)));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/miss")).willReturn(WireMock.aResponse().withStatus(404)));
        this.client.get("/hit", new TestHttpHeader[0]);
    }

    @Test
    public void unmatchedRequestWithoutStubShouldThrowVerificationException() {
        this.expectedException.expect(VerificationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"A request was unmatched by any stub mapping."));
        this.expectedException.expectMessage(Matchers.containsString((String)"\"url\" : \"/miss\""));
        this.client.get("/miss", new TestHttpHeader[0]);
    }

    @Test
    public void unmatchedStubWithoutRequestShouldNotThrowVerificationException() {
        this.expectedException = ExpectedException.none();
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/miss")).willReturn(WireMock.aResponse().withStatus(404)));
    }
}

