/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit5;

import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class JUnitJupiterExtensionDeclarativeProgrammaticMixTest {

    @WireMockTest(httpPort=44778)
    public static class TestNoInstanceOverride {
        @RegisterExtension
        public WireMockExtension wmi = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().port(44351)).build();

        @Test
        void programmatic_port_option_used_when_no_port_specified_in_attributes_instance() {
            int port = this.wmi.getPort();
            MatcherAssert.assertThat((Object)port, (Matcher)Matchers.is((Object)44351));
        }

        @Test
        void programmatic_port_is_different_from_declarative_port(WireMockRuntimeInfo wmRuntimeInfo) {
            int declarativePort = wmRuntimeInfo.getHttpPort();
            int staticMemberPort = this.wmi.getPort();
            MatcherAssert.assertThat((Object)staticMemberPort, (Matcher)Matchers.is((Matcher)Matchers.not((Object)declarativePort)));
        }

        @Test
        void wiremockruntimeinfo_always_injects_declarative_instance(WireMockRuntimeInfo wmRuntimeInfo) {
            WireMockRuntimeInfo staticMemberRuntimeInfo = this.wmi.getRuntimeInfo();
            MatcherAssert.assertThat((Object)wmRuntimeInfo, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)wmRuntimeInfo, (Matcher)Matchers.is((Matcher)Matchers.not((Object)staticMemberRuntimeInfo)));
        }
    }

    @WireMockTest
    public static class TestSaneInstanceDefaults {
        @RegisterExtension
        public WireMockExtension wmi = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().port(44349)).build();

        @Test
        void programmatic_port_option_used_when_no_port_specified_in_attributes_instance() {
            int port = this.wmi.getPort();
            MatcherAssert.assertThat((Object)port, (Matcher)Matchers.is((Object)44349));
        }

        @Test
        void programmatic_port_is_different_from_declarative_port(WireMockRuntimeInfo wmRuntimeInfo) {
            int declarativePort = wmRuntimeInfo.getHttpPort();
            int staticMemberPort = this.wmi.getPort();
            MatcherAssert.assertThat((Object)staticMemberPort, (Matcher)Matchers.is((Matcher)Matchers.not((Object)declarativePort)));
        }

        @Test
        void wiremockruntimeinfo_always_injects_declarative_instance(WireMockRuntimeInfo wmRuntimeInfo) {
            WireMockRuntimeInfo staticMemberRuntimeInfo = this.wmi.getRuntimeInfo();
            MatcherAssert.assertThat((Object)wmRuntimeInfo, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)wmRuntimeInfo, (Matcher)Matchers.is((Matcher)Matchers.not((Object)staticMemberRuntimeInfo)));
        }
    }

    @WireMockTest(httpPort=44777)
    public static class TestNoStaticOverride {
        @RegisterExtension
        public static WireMockExtension wms = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().port(44346)).build();

        @Test
        void programmatic_and_declarative_ports_are_as_defined(WireMockRuntimeInfo wmRuntimeInfo) {
            int declarativePort = wmRuntimeInfo.getHttpPort();
            int staticMemberPort = wms.getPort();
            MatcherAssert.assertThat((Object)staticMemberPort, (Matcher)Matchers.is((Object)44346));
            MatcherAssert.assertThat((Object)declarativePort, (Matcher)Matchers.is((Object)44777));
        }
    }

    @WireMockTest
    public static class TestSaneStaticDefaults {
        @RegisterExtension
        public static WireMockExtension wms = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().port(44345)).build();

        @Test
        void programmatic_port_option_used_when_no_port_specified_in_attributes_static() {
            int port = wms.getPort();
            MatcherAssert.assertThat((Object)port, (Matcher)Matchers.is((Object)44345));
        }

        @Test
        void programmatic_port_is_different_from_declarative_port(WireMockRuntimeInfo wmRuntimeInfo) {
            int declarativePort = wmRuntimeInfo.getHttpPort();
            int staticMemberPort = wms.getPort();
            MatcherAssert.assertThat((Object)staticMemberPort, (Matcher)Matchers.is((Matcher)Matchers.not((Object)declarativePort)));
        }

        @Test
        void wiremockruntimeinfo_always_injects_declarative_instance(WireMockRuntimeInfo wmRuntimeInfo) {
            WireMockRuntimeInfo staticMemberRuntimeInfo = wms.getRuntimeInfo();
            MatcherAssert.assertThat((Object)wmRuntimeInfo, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)wmRuntimeInfo, (Matcher)Matchers.is((Matcher)Matchers.not((Object)staticMemberRuntimeInfo)));
        }
    }
}

