/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit5;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@WireMockTest(httpsEnabled=true)
public class JUnitJupiterExtensionDeclarativeWithRandomHttpsPortParameterTest {
    CloseableHttpClient client;

    @BeforeEach
    void init() {
        this.client = HttpClientFactory.createClient();
    }

    @Test
    void runs_on_a_random_port_when_enabled(WireMockRuntimeInfo wmRuntimeInfo) throws Exception {
        Assertions.assertTrue((boolean)wmRuntimeInfo.isHttpsEnabled(), (String)"Expected HTTPS to be enabled");
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/thing").willReturn(WireMock.ok()));
        HttpGet request = new HttpGet(wmRuntimeInfo.getHttpsBaseUrl() + "/thing");
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)request);){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        }
    }
}

