/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit5;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.RegisterExtension;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class JUnitJupiterExtensionNonStaticMultiInstanceTest {
    CloseableHttpClient client;
    @RegisterExtension
    WireMockExtension wm1 = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort()).configureStaticDsl(true).build();
    @RegisterExtension
    WireMockExtension wm2 = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().templatingEnabled(true).globalTemplating(true)).build();

    @BeforeEach
    void init() {
        this.client = HttpClientFactory.createClient();
    }

    @Test
    @Order(value=1)
    void extension_field_provides_wiremock_info() throws Exception {
        WireMockRuntimeInfo wm1RuntimeInfo = this.wm1.getRuntimeInfo();
        Assertions.assertDoesNotThrow(() -> ((WireMockRuntimeInfo)wm1RuntimeInfo).getHttpsPort());
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/wm1").willReturn(WireMock.ok()));
        HttpGet request = new HttpGet(wm1RuntimeInfo.getHttpsBaseUrl() + "/wm1");
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)request);){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        }
        WireMockRuntimeInfo wm2RuntimeInfo = this.wm2.getRuntimeInfo();
        this.wm2.stubFor(WireMock.get((String)"/wm2").willReturn(WireMock.ok((String)"{{request.path.0}}")));
        request = new HttpGet(wm2RuntimeInfo.getHttpBaseUrl() + "/wm2");
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)request);){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity()), (Matcher)Matchers.is((Object)"wm2"));
        }
    }

    @Test
    @Order(value=2)
    void wiremock_is_reset_between_tests() throws Exception {
        WireMockRuntimeInfo wm1RuntimeInfo = this.wm1.getRuntimeInfo();
        Assertions.assertTrue((boolean)WireMock.getAllServeEvents().isEmpty(), (String)"The request log should be empty");
        HttpGet request = new HttpGet(wm1RuntimeInfo.getHttpsBaseUrl() + "/wm1");
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)request);){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)404));
        }
    }
}

