/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit5;

import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import ignored.JupiterExtensionTestClass;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.testkit.engine.EngineTestKit;
import org.junit.platform.testkit.engine.Events;

public class JUnitJupiterExtensionSubclassingTest {
    @BeforeEach
    public void beforeEach() {
        MyWireMockExtension.reset();
    }

    @Test
    void executes_all_lifecycle_callbacks() {
        Events testEvents = EngineTestKit.engine((String)"junit-jupiter").selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(JupiterExtensionTestClass.class)}).execute().testEvents();
        testEvents.assertStatistics(stats -> stats.succeeded(1L));
        MatcherAssert.assertThat((Object)MyWireMockExtension.beforeAllCalled, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)MyWireMockExtension.beforeEachCalled, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)MyWireMockExtension.afterEachCalled, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)MyWireMockExtension.afterAllCalled, (Matcher)Matchers.is((Object)true));
    }

    public static class MyWireMockExtension
    extends WireMockExtension {
        public static boolean beforeAllCalled = false;
        public static boolean beforeEachCalled = false;
        public static boolean afterEachCalled = false;
        public static boolean afterAllCalled = false;

        public MyWireMockExtension(WireMockExtension.Builder builder) {
            super(builder);
        }

        protected void onBeforeAll(WireMockRuntimeInfo wireMockRuntimeInfo) {
            beforeAllCalled = true;
        }

        protected void onBeforeEach(WireMockRuntimeInfo wireMockRuntimeInfo) {
            beforeEachCalled = true;
        }

        protected void onAfterEach(WireMockRuntimeInfo wireMockRuntimeInfo) {
            afterEachCalled = true;
        }

        protected void onAfterAll(WireMockRuntimeInfo wireMockRuntimeInfo) {
            afterAllCalled = true;
        }

        public static void reset() {
            beforeAllCalled = false;
            beforeEachCalled = false;
            afterEachCalled = false;
            afterAllCalled = false;
        }
    }
}

