/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import java.util.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

class BinaryEqualToPatternPatternTest {
    BinaryEqualToPatternPatternTest() {
    }

    @Test
    void returns1ForNonMatch() {
        BinaryEqualToPattern pattern = WireMock.binaryEqualTo((byte[])new byte[]{1, 2, 3});
        byte[] actual = new byte[]{4, 5, 6};
        MatchResult match = pattern.match((Object)actual);
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void returns0WhenExactlyEqual() {
        BinaryEqualToPattern pattern = WireMock.binaryEqualTo((byte[])new byte[]{1, 2, 3});
        byte[] actual = new byte[]{1, 2, 3};
        MatchResult match = pattern.match((Object)actual);
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)0.0));
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void returnsNonMatchWheActualIsNull() {
        BinaryEqualToPattern pattern = WireMock.binaryEqualTo((byte[])new byte[]{1, 2, 3});
        Object actual = null;
        MatchResult match = pattern.match(actual);
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)match.isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void serialisesCorrectly() throws Exception {
        byte[] expected = new byte[]{5, 5, 5, 5};
        String base64Expected = Base64.getEncoder().encodeToString(expected);
        String expectedJson = "{                                                   \n  \"binaryEqualTo\": \"" + base64Expected + "\"     \n}";
        JSONAssert.assertEquals((String)expectedJson, (String)Json.write((Object)new BinaryEqualToPattern(expected)), (boolean)true);
    }

    @Test
    void deserializesCorrectly() {
        String base64Expected = Base64.getEncoder().encodeToString(new byte[]{1, 2, 3});
        ContentPattern pattern = (ContentPattern)Json.read((String)("{                                              \n  \"binaryEqualTo\": \"" + base64Expected + "\"    \n}"), ContentPattern.class);
        MatcherAssert.assertThat((Object)pattern, (Matcher)Matchers.instanceOf(BinaryEqualToPattern.class));
        MatcherAssert.assertThat((Object)pattern.getExpected(), (Matcher)Matchers.is((Object)base64Expected));
    }

    @Test
    void objectsShouldBeEqualOnSameExpectedValue() {
        BinaryEqualToPattern a = new BinaryEqualToPattern(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        BinaryEqualToPattern b = new BinaryEqualToPattern(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        BinaryEqualToPattern c = new BinaryEqualToPattern(new byte[]{0, 8, 15});
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((int)a.hashCode(), (int)c.hashCode());
        Assertions.assertNotEquals((Object)b, (Object)c);
        Assertions.assertNotEquals((int)b.hashCode(), (int)c.hashCode());
    }
}

