/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.PathTemplatePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class PathTemplatePatternTest {
    @Test
    void returns_exact_match_when_path_matches_template() {
        PathTemplatePattern pattern = new PathTemplatePattern("/one/{id}/two");
        MatcherAssert.assertThat((Object)pattern.match("/one/3/two").isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void returns_no_match_and_low_distance_when_path_almost_matches_template() {
        PathTemplatePattern pattern = new PathTemplatePattern("/one/{id}/two");
        MatchResult matchResult = pattern.match("/on/3/two");
        MatcherAssert.assertThat((Object)matchResult.isExactMatch(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.closeTo((double)0.2, (double)0.05));
    }

    @Test
    void returns_no_match_and_high_distance_when_path_is_very_different_from_template() {
        PathTemplatePattern pattern = new PathTemplatePattern("/one/{id}/two");
        MatchResult matchResult = pattern.match("/totally/different/stuff/and/length");
        MatcherAssert.assertThat((Object)matchResult.isExactMatch(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.closeTo((double)0.9, (double)0.05));
    }

    @Test
    void serialises_correctly() {
        PathTemplatePattern pattern = new PathTemplatePattern("/one/{first}/two/{second}");
        String json = Json.write((Object)pattern);
        MatcherAssert.assertThat((Object)json, (Matcher)JsonMatchers.jsonEquals((Object)"{\n  \"matchesPathTemplate\": \"/one/{first}/two/{second}\"\n}"));
    }

    @Test
    void deserialises_correcltly() {
        StringValuePattern pattern = (StringValuePattern)Json.read((String)"{\n  \"matchesPathTemplate\": \"/one/{first}/two/{second}\"\n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)pattern, (Matcher)Matchers.instanceOf(PathTemplatePattern.class));
        MatcherAssert.assertThat((Object)((PathTemplatePattern)pattern).getPathTemplate().toString(), (Matcher)Matchers.is((Object)"/one/{first}/two/{second}"));
    }
}

