/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class RegexValuePatternTest {
    @Test
    public void correctlySerialisesMatchesAsJson() throws Exception {
        String actual = Json.write((Object)WireMock.matching((String)"something"));
        System.out.println(actual);
        JSONAssert.assertEquals((String)"{                               \n  \"matches\": \"something\"    \n}", (String)actual, (boolean)true);
    }

    @Test
    public void correctlyDeserialisesMatchesFromJson() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                               \n  \"matches\": \"something\"    \n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(RegexPattern.class));
        MatcherAssert.assertThat((Object)((String)stringValuePattern.getValue()), (Matcher)Matchers.is((Object)"something"));
    }

    @Test
    public void noMatchWhenValueIsNull() {
        MatcherAssert.assertThat((Object)WireMock.matching((String)".*").match(null).isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void objectsShouldBeEqualOnSameExpectedValue() {
        RegexPattern a = new RegexPattern("test");
        RegexPattern b = new RegexPattern("test");
        RegexPattern c = new RegexPattern("anotherTest");
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((Object)b, (Object)a);
        Assertions.assertEquals((int)b.hashCode(), (int)a.hashCode());
        Assertions.assertNotEquals((Object)a, (Object)c);
        Assertions.assertNotEquals((int)a.hashCode(), (int)c.hashCode());
        Assertions.assertNotEquals((Object)b, (Object)c);
        Assertions.assertNotEquals((int)b.hashCode(), (int)c.hashCode());
    }
}

