/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.servlet.WireMockHandlerDispatchingServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class AltHttpServerFactory
implements HttpServerFactory {
    public HttpServer buildHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        final Server jettyServer = new Server(0);
        ConsoleNotifier notifier = new ConsoleNotifier(false);
        ServletContextHandler adminContext = this.addAdminContext(jettyServer, adminRequestHandler, (Notifier)notifier);
        ServletContextHandler mockServiceContext = this.addMockServiceContext(jettyServer, stubRequestHandler, options.filesRoot(), (Notifier)notifier);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{adminContext, mockServiceContext});
        jettyServer.setHandler((Handler)handlers);
        return new HttpServer(){

            public void start() {
                try {
                    jettyServer.start();
                }
                catch (Exception e) {
                    Exceptions.throwUnchecked((Throwable)e);
                }
            }

            public void stop() {
                try {
                    jettyServer.stop();
                }
                catch (Exception e) {
                    Exceptions.throwUnchecked((Throwable)e);
                }
            }

            public boolean isRunning() {
                return jettyServer.isRunning();
            }

            public int port() {
                return ((ServerConnector)jettyServer.getConnectors()[0]).getLocalPort();
            }

            public int httpsPort() {
                return 0;
            }
        };
    }

    private ServletContextHandler addMockServiceContext(Server jettyServer, StubRequestHandler stubRequestHandler, FileSource fileSource, Notifier notifier) {
        ServletContextHandler mockServiceContext = new ServletContextHandler((HandlerContainer)jettyServer, "/");
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), (Object)stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", (Object)notifier);
        ServletHolder servletHolder = mockServiceContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "false");
        return mockServiceContext;
    }

    private ServletContextHandler addAdminContext(Server jettyServer, AdminRequestHandler adminRequestHandler, Notifier notifier) {
        ServletContextHandler adminContext = new ServletContextHandler((HandlerContainer)jettyServer, "/__admin");
        ServletHolder servletHolder = adminContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), (Object)adminRequestHandler);
        adminContext.setAttribute("Notifier", (Object)notifier);
        return adminContext;
    }
}

