/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.servlet.BodyChunker;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class BodyChunkerTest {
    @Test
    public void returnsBodyAsSingleChunkWhenChunkSizeIsOne() {
        byte[] body = "1234".getBytes();
        int numberOfChunks = 1;
        byte[][] chunkedBody = BodyChunker.chunkBody((byte[])body, (int)numberOfChunks);
        MatcherAssert.assertThat((Object)chunkedBody, (Matcher)Matchers.arrayWithSize((int)numberOfChunks));
        MatcherAssert.assertThat((Object)chunkedBody[0], (Matcher)Matchers.equalTo((Object)body));
    }

    @Test
    public void returnsEvenlyChunkedBody() {
        byte[] body = "1234".getBytes();
        int numberOfChunks = 2;
        byte[][] chunkedBody = BodyChunker.chunkBody((byte[])body, (int)numberOfChunks);
        MatcherAssert.assertThat((Object)chunkedBody, (Matcher)Matchers.arrayWithSize((int)numberOfChunks));
        MatcherAssert.assertThat((Object)chunkedBody[0], (Matcher)Matchers.equalTo((Object)"12".getBytes()));
        MatcherAssert.assertThat((Object)chunkedBody[1], (Matcher)Matchers.equalTo((Object)"34".getBytes()));
    }

    @Test
    public void addsExcessBytesToLastChunk() {
        byte[] body = "1234".getBytes();
        int numberOfChunks = 3;
        byte[][] chunkedBody = BodyChunker.chunkBody((byte[])body, (int)numberOfChunks);
        MatcherAssert.assertThat((Object)chunkedBody, (Matcher)Matchers.arrayWithSize((int)numberOfChunks));
        MatcherAssert.assertThat((Object)chunkedBody[0], (Matcher)Matchers.equalTo((Object)"1".getBytes()));
        MatcherAssert.assertThat((Object)chunkedBody[1], (Matcher)Matchers.equalTo((Object)"2".getBytes()));
        MatcherAssert.assertThat((Object)chunkedBody[2], (Matcher)Matchers.equalTo((Object)"34".getBytes()));
    }

    @Test
    public void defaultsChunkSizeToOneIfNumberOfChunksGreaterThenBodyLength() {
        byte[] body = "1234".getBytes();
        int numberOfChunks = 5;
        byte[][] chunkedBody = BodyChunker.chunkBody((byte[])body, (int)numberOfChunks);
        MatcherAssert.assertThat((Object)chunkedBody, (Matcher)Matchers.arrayWithSize((int)body.length));
        MatcherAssert.assertThat((Object)chunkedBody[0], (Matcher)Matchers.equalTo((Object)"1".getBytes()));
        MatcherAssert.assertThat((Object)chunkedBody[1], (Matcher)Matchers.equalTo((Object)"2".getBytes()));
        MatcherAssert.assertThat((Object)chunkedBody[2], (Matcher)Matchers.equalTo((Object)"3".getBytes()));
        MatcherAssert.assertThat((Object)chunkedBody[3], (Matcher)Matchers.equalTo((Object)"4".getBytes()));
    }

    @Test
    public void defaultsChunkSizeToOneIfNumberOfChunksLessThanOne() {
        byte[] body = "1234".getBytes();
        int numberOfChunks = -1;
        byte[][] chunkedBody = BodyChunker.chunkBody((byte[])body, (int)numberOfChunks);
        MatcherAssert.assertThat((Object)chunkedBody, (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)chunkedBody[0], (Matcher)Matchers.equalTo((Object)body));
    }
}

