/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.ProxySettings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxySettingsTest {
    @Test
    public void throwsExceptionWhenHostPartNotSpecified() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ProxySettings.fromString((String)":8090"));
    }

    @Test
    public void defaultsToPort80() {
        MatcherAssert.assertThat((Object)ProxySettings.fromString((String)"myhost.com").port(), (Matcher)Matchers.is((Object)80));
    }

    @Test
    public void parsesHostAndPortCorrectly() {
        ProxySettings settings = ProxySettings.fromString((String)"some.host.org:8888");
        MatcherAssert.assertThat((Object)settings.host(), (Matcher)Matchers.is((Object)"some.host.org"));
        MatcherAssert.assertThat((Object)settings.port(), (Matcher)Matchers.is((Object)8888));
    }
}

