/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.common.Json;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonTest {
    private static final String TEST_VALUE = "test-value";
    private static final String JSON_WITH_NO_COMMENTS = "{                                          \n\"property\": \"test-value\"   \n}";
    private static final String JSON_WITH_SINGLE_QUOTES = "{                                            \n'property': 'test-value'         \n}";
    private static final String JSON_WITH_COMMENTS = "// this is the first comment                                                   \n{                                                                              \n//this is a comment                                                    \n\"property\": \"test-value\"// comment on same line as code    \n}                                                                              \n//this is the last comment";

    @Test
    public void testReadNoComments() {
        TestPojo pojo = (TestPojo)Json.read((String)JSON_WITH_NO_COMMENTS, TestPojo.class);
        Assertions.assertNotNull((Object)pojo);
        MatcherAssert.assertThat((Object)TEST_VALUE, (Matcher)Matchers.is((Object)pojo.property));
    }

    @Test
    public void testReadWithComments() {
        TestPojo pojo = (TestPojo)Json.read((String)JSON_WITH_COMMENTS, TestPojo.class);
        Assertions.assertNotNull((Object)pojo);
        MatcherAssert.assertThat((Object)TEST_VALUE, (Matcher)Matchers.is((Object)pojo.property));
    }

    @Test
    public void testReadWithSingleQuotes() {
        TestPojo pojo = (TestPojo)Json.read((String)JSON_WITH_SINGLE_QUOTES, TestPojo.class);
        Assertions.assertNotNull((Object)pojo);
        MatcherAssert.assertThat((Object)TEST_VALUE, (Matcher)Matchers.is((Object)pojo.property));
    }

    @Test
    public void countsAllNodesInADocument() {
        int count = Json.deepSize((JsonNode)Json.node((String)"{\n    \"one\": \"GET\",\n    \"two\": 2,\n    \"queryParameters\": {\n        \"param1\": {\n            \"equalTo\": \"1\"\n        },\n        \"param2\": {\n            \"matches\": \"2\"\n        }\n    },\n    \"things\": [1, 2, 3],\n    \"deepThings\": [\n        { \"deep1\": 1 },\n        { \"deep2\": 2 }\n    ]\n}"));
        MatcherAssert.assertThat((Object)count, (Matcher)Matchers.is((Object)24));
    }

    @Test
    public void counts1ForEmptyArray() {
        int count = Json.deepSize((JsonNode)Json.node((String)"[]"));
        MatcherAssert.assertThat((Object)count, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void counts1ForEmptyObject() {
        int count = Json.deepSize((JsonNode)Json.node((String)"{}"));
        MatcherAssert.assertThat((Object)count, (Matcher)Matchers.is((Object)1));
    }

    private static class TestPojo {
        public String property;

        private TestPojo() {
        }
    }
}

