/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.IdGenerator;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.matching.MockMultipart;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.stubbing.StubMappingJsonRecorder;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class StubMappingJsonRecorderTest {
    private StubMappingJsonRecorder listener;
    private BlobStore mappingsBlobStore;
    private BlobStore filesBlobStore;
    private Admin admin;
    private static final String SAMPLE_REQUEST_MAPPING = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"request\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"method\": \"GET\",\t\t\t\t\t\t             \n\t\t\"url\": \"/recorded/content\"\t\t\t\t             \n\t},\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"response\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"status\": 200,\t\t\t\t\t\t\t             \n\t\t\"bodyFileName\": \"body-recorded-content-1$2!3.txt\"    \n\t}\t\t\t\t\t\t\t\t\t\t\t\t             \n}\t\t\t\t\t\t\t\t\t\t\t\t\t               ";
    private static final String SAMPLE_REQUEST_MAPPING_WITH_HEADERS = "{                                                                  \n   \"request\": {                                                  \n       \"method\": \"GET\",                                        \n       \"url\": \"/headered/content\"                              \n   },                                                              \n   \"response\": {                                                 \n       \"status\": 200,                                            \n       \"bodyFileName\": \"body-headered-content-1$2!3.txt\",      \n       \"headers\": {                                              \n            \"Content-Type\": \"text/plain\",                      \n            \"Cache-Control\": \"no-cache\"                        \n       }                                                           \n   }                                                               \n}                                                                  ";
    private static final String SAMPLE_REQUEST_MAPPING_WITH_BODY = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"request\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"method\": \"POST\",\t\t\t\t\t\t             \n\t\t\"url\": \"/body/content\",                              \n       \"bodyPatterns\": [                                      \n            { \"equalTo\": \"somebody\" }                       \n        ]\t\t\t\t                                         \n\t},\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"response\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"status\": 200, \t\t\t\t\t\t\t             \n\t\t\"bodyFileName\": \"body-body-content-1$2!3.txt\"        \n\t}\t\t\t\t\t\t\t\t\t\t\t\t             \n}\t\t\t\t\t\t\t\t\t\t\t\t\t               ";
    private static final String SAMPLE_REQUEST_MAPPING_WITH_REQUEST_HEADERS_1 = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"request\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"method\": \"GET\",\t\t\t\t\t\t             \n\t\t\"url\": \"/same/url\",                             \t \n       \"headers\": {                                       \t \n\t\t\t \"Accept\":\t\t\t\t\t\t\t\t\t\t \n            \t{ \"equalTo\": \"text/html\" }            \t\t \n        }\t\t\t\t                                         \n\t},\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"response\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"status\": 200,\t\t\t\t\t\t\t             \n\t\t\"bodyFileName\": \"body-same-url-1$2!3.txt\"\t\t \t \n\t}\t\t\t\t\t\t\t\t\t\t\t\t             \n}\t\t\t\t\t\t\t\t\t\t\t\t\t               ";
    private static final String SAMPLE_REQUEST_MAPPING_WITH_REQUEST_HEADERS_2 = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"request\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"method\": \"GET\",\t\t\t\t\t\t             \n\t\t\"url\": \"/same/url\",                             \t \n       \"headers\": {                                       \t \n\t\t\t \"Accept\":\t\t\t\t\t\t\t\t\t\t \n            \t{ \"equalTo\": \"application/json\" }            \n        }\t\t\t\t                                         \n\t},\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"response\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"status\": 200, \t\t\t\t\t\t\t             \n\t\t\"bodyFileName\": \"body-same-url-1$2!3.txt\"\t\t \t \n\t}\t\t\t\t\t\t\t\t\t\t\t\t             \n}\t\t\t\t\t\t\t\t\t\t\t\t\t               ";
    private static final List<String> MATCHING_REQUEST_HEADERS = new ArrayList<String>(Collections.singletonList("Accept"));
    private static final String SAMPLE_REQUEST_MAPPING_WITH_JSON_BODY = "{                                                          \n  \"request\" : {                                          \n    \"url\" : \"/json/content\",                           \n    \"method\" : \"POST\",                                 \n    \"bodyPatterns\" : [ {                                 \n      \"equalToJson\" : \"{}\",                            \n      \"ignoreArrayOrder\" : true,                         \n      \"ignoreExtraElements\" : true                       \n    } ]                                                    \n  },                                                       \n  \"response\" : {                                         \n    \"status\" : 200,                                      \n    \"bodyFileName\" : \"body-json-content-1$2!3.txt\"     \n  }                                                        \n}";
    private static final String SAMPLE_REQUEST_MAPPING_WITH_XML_BODY = "{                                                                  \n  \"request\" : {                                                  \n    \"url\" : \"/xml/content\",                                    \n    \"method\" : \"POST\",                                         \n    \"bodyPatterns\" : [ {                                         \n      \"equalToXml\" : \"<stuff />\"                               \n    } ]                                                            \n  },                                                               \n  \"response\" : {                                                 \n    \"status\" : 200,                                              \n    \"bodyFileName\" : \"body-xml-content-1$2!3.txt\"              \n  }                                                                \n}";
    private static final String GZIP_REQUEST_MAPPING = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t             \n   \"id\": \"41544750-0c69-3fd7-93b1-f79499f987c3\",            \n   \"uuid\": \"41544750-0c69-3fd7-93b1-f79499f987c3\",          \n\t\"request\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"method\": \"GET\",\t\t\t\t\t\t             \n\t\t\"url\": \"/gzipped/content\"\t\t\t\t             \n\t},\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"response\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"status\": 200,\t\t\t\t\t\t\t             \n\t\t\"bodyFileName\": \"body-gzipped-content-1$2!3.txt\"     \n\t}\t\t\t\t\t\t\t\t\t\t\t\t             \n}\t\t\t\t\t\t\t\t\t\t\t\t\t               ";
    private static final String MULTIPART_REQUEST_MAPPING = "{\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"id\": \"41544750-0c69-3fd7-93b1-f79499f987c3\",\t\t\t\t\n\t\"uuid\": \"41544750-0c69-3fd7-93b1-f79499f987c3\",\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"POST\",\t\t\t\t\t\t\t\t\t\t\n\t\t\"url\": \"/multipart/content\",\t\t\t\t\t\t\t\n\t\t\"multipartPatterns\" : [ {\t\t\t\t\t\t\t\t\t\n\t\t\t\"name\" : \"binaryFile\",\t\t\t\t\t\t\t\t\n\t\t\t\"matchingType\" : \"ALL\",\t\t\t\t\t\t\t\t\n\t\t\t\"headers\" : {\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\"Content-Disposition\" : {\t\t\t\t\t\t\t\n\t\t\t\t\t\"contains\" : \"name=\\\"binaryFile\\\"\"\t\t\n\t\t\t    }\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t},\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\"bodyPatterns\" : [ {\t\t\t\t\t\t\t\t\t\n\t\t\t\t\"binaryEqualTo\" : \"VGhpcyBhIGZpbGUgY29udGVudA==\"\n\t\t\t} ]\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t}, {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\"name\" : \"textFile\",\t\t\t\t\t\t\t\t\n\t\t\t\"matchingType\" : \"ALL\",\t\t\t\t\t\t\t\t\n\t\t\t\"headers\" : {\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\"Content-Disposition\" : {\t\t\t\t\t\t\t\n\t\t\t\t\t\"contains\" : \"name=\\\"textFile\\\"\"\t\t\n\t\t\t    }\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t},\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\"bodyPatterns\" : [ {\t\t\t\t\t\t\t\t\t\n\t\t\t\t\"equalTo\" : \"This a file content\"\t\t\t\t\n\t\t\t} ]\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t}, {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\"name\" : \"formInput\",\t\t\t\t\t\t\t\t\n\t\t\t\"matchingType\" : \"ALL\",\t\t\t\t\t\t\t\t\n\t\t\t\"headers\" : {\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\"Content-Disposition\" : {\t\t\t\t\t\t\t\n\t\t\t\t\t\"contains\" : \"name=\\\"formInput\\\"\"\t\t\n\t\t\t\t},\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t},\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\"bodyPatterns\" : [ {\t\t\t\t\t\t\t\t\t\n\t\t\t\t\"equalTo\" : \"I am a field!\"\t\t\t\t\t\t\n\t\t\t} ]\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t} ]\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t            \t\n\t\"response\": {\t\t\t\t\t\t\t\t\t            \t\n\t\t\"status\": 200,\t\t\t\t\t\t\t            \t\n\t\t\"bodyFileName\": \"body-multipart-content-1$2!3.txt\"  \t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t            \t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final String BAD_MULTIPART_REQUEST_MAPPING = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"id\": \"41544750-0c69-3fd7-93b1-f79499f987c3\",\t\t\t\t\n\t\"uuid\": \"41544750-0c69-3fd7-93b1-f79499f987c3\",\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"url\": \"/multipart/content\",                         \n\t\t\"method\": \"POST\" \t\t\t\t\t\t             \n\t},\t\t\t\t\t\t\t\t\t\t\t\t             \n\t\"response\": {\t\t\t\t\t\t\t\t\t             \n\t\t\"status\": 200, \t\t\t\t\t\t\t             \n\t\t\"bodyFileName\": \"body-multipart-content-1$2!3.txt\"        \n\t}\t\t\t\t\t\t\t\t\t\t\t\t             \n}";

    @BeforeEach
    public void init() {
        this.mappingsBlobStore = (BlobStore)Mockito.mock(BlobStore.class, (String)"mappingsBlobStore");
        this.filesBlobStore = (BlobStore)Mockito.mock(BlobStore.class, (String)"filesBlobStore");
        this.admin = (Admin)Mockito.mock(Admin.class);
        this.constructRecordingListener(Collections.emptyList());
    }

    private void constructRecordingListener(List<String> headersToRecord) {
        this.listener = new StubMappingJsonRecorder(this.mappingsBlobStore, this.filesBlobStore, this.admin, headersToRecord.stream().map(CaseInsensitiveKey.TO_CASE_INSENSITIVE_KEYS).collect(Collectors.toUnmodifiableList()));
        this.listener.setIdGenerator(this.fixedIdGenerator("1$2!3"));
    }

    @Test
    public void writesMappingFileAndCorrespondingBodyFileOnRequest() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withMethod(RequestMethod.GET).withUrl("/recorded/content").build();
        Response response = Response.response().status(200).fromProxy(true).body("Recorded body content").build();
        this.listener.requestReceived(request, response);
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.eq((Object)"mapping-recorded-content-1$2!3.json")), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.equalToBinaryJson(SAMPLE_REQUEST_MAPPING, JSONCompareMode.STRICT_ORDER))));
        ((BlobStore)Mockito.verify((Object)this.filesBlobStore)).put((Object)((String)ArgumentMatchers.eq((Object)"body-recorded-content-1$2!3.txt")), (Object)((byte[])ArgumentMatchers.eq((Object)"Recorded body content".getBytes(StandardCharsets.UTF_8))));
    }

    @Test
    public void addsResponseHeaders() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withMethod(RequestMethod.GET).withUrl("/headered/content").build();
        Response response = Response.response().status(200).fromProxy(true).body("Recorded body content").headers(new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Content-Type", (String[])new String[]{"text/plain"}), HttpHeader.httpHeader((String)"Cache-Control", (String[])new String[]{"no-cache"})})).build();
        this.listener.requestReceived(request, response);
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.eq((Object)"mapping-headered-content-1$2!3.json")), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.equalToBinaryJson(SAMPLE_REQUEST_MAPPING_WITH_HEADERS, JSONCompareMode.STRICT_ORDER))));
        ((BlobStore)Mockito.verify((Object)this.filesBlobStore)).put((Object)"body-headered-content-1$2!3.txt", (Object)"Recorded body content".getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void doesNotWriteFileIfRequestAlreadyReceived() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)1));
        this.listener.requestReceived(new MockRequestBuilder().withMethod(RequestMethod.GET).withUrl("/headered/content").build(), Response.response().fromProxy(true).status(200).build());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mappingsBlobStore});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mappingsBlobStore});
    }

    @Test
    public void doesNotWriteFileIfResponseNotFromProxy() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Response response = Response.response().status(200).fromProxy(false).build();
        this.listener.requestReceived(new MockRequestBuilder().withMethod(RequestMethod.GET).withUrl("/headered/content").build(), response);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mappingsBlobStore});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.filesBlobStore});
    }

    @Test
    public void includesBodyInRequestPatternIfInRequest() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withMethod(RequestMethod.POST).withUrl("/body/content").withHeader("Content-Type", "text/plain").withBody("somebody").build();
        this.listener.requestReceived(request, Response.response().status(200).body("anything").fromProxy(true).build());
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.any(String.class)), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.equalToBinaryJson(SAMPLE_REQUEST_MAPPING_WITH_BODY, JSONCompareMode.STRICT_ORDER))));
    }

    @Test
    public void includesHeadersInRequestPatternIfHeaderMatchingEnabled() {
        this.constructRecordingListener(MATCHING_REQUEST_HEADERS);
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request1 = new MockRequestBuilder("MockRequestAcceptHtml").withMethod(RequestMethod.GET).withUrl("/same/url").withHeader("Accept", "text/html").build();
        Request request2 = new MockRequestBuilder("MockRequestAcceptJson").withMethod(RequestMethod.GET).withUrl("/same/url").withHeader("Accept", "application/json").build();
        this.listener.requestReceived(request1, Response.response().status(200).fromProxy(true).build());
        this.listener.requestReceived(request2, Response.response().status(200).fromProxy(true).build());
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.any(String.class)), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.equalToBinaryJson(SAMPLE_REQUEST_MAPPING_WITH_REQUEST_HEADERS_1, JSONCompareMode.STRICT_ORDER))));
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.any(String.class)), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.equalToBinaryJson(SAMPLE_REQUEST_MAPPING_WITH_REQUEST_HEADERS_2, JSONCompareMode.STRICT_ORDER))));
    }

    @Test
    public void matchesBodyOnEqualToJsonIfJsonInRequestContentTypeHeader() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withMethod(RequestMethod.POST).withUrl("/json/content").withHeader("Content-Type", "application/json ").withBody("{}").build();
        this.listener.requestReceived(request, Response.response().status(200).body("anything").fromProxy(true).build());
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.any(String.class)), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.equalToBinaryJson(SAMPLE_REQUEST_MAPPING_WITH_JSON_BODY, JSONCompareMode.STRICT_ORDER))));
    }

    @Test
    public void matchesBodyOnEqualToXmlIfXmlInRequestContentTypeHeader() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withMethod(RequestMethod.POST).withUrl("/xml/content").withHeader("Content-Type", "text/xml; content-type=utf-8").withBody("<stuff />").build();
        this.listener.requestReceived(request, Response.response().status(200).body("anything").fromProxy(true).build());
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.any(String.class)), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.equalToBinaryJson(SAMPLE_REQUEST_MAPPING_WITH_XML_BODY, JSONCompareMode.STRICT_ORDER))));
    }

    @Test
    public void decompressesGzippedResponseBodyAndRemovesContentEncodingHeader() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withHeader("Accept-Encoding", "gzip").withMethod(RequestMethod.GET).withUrl("/gzipped/content").build();
        Response response = Response.response().status(200).fromProxy(true).headers(new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Content-Encoding", (String[])new String[]{"gzip"}), HttpHeader.httpHeader((String)"Content-Length", (String[])new String[]{"123"})})).body(Gzip.gzip((String)"Recorded body content")).build();
        this.listener.requestReceived(request, response);
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.eq((Object)"mapping-gzipped-content-1$2!3.json")), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.equalToBinaryJson(GZIP_REQUEST_MAPPING, JSONCompareMode.STRICT))));
        ((BlobStore)Mockito.verify((Object)this.filesBlobStore)).put((Object)((String)ArgumentMatchers.eq((Object)"body-gzipped-content-1$2!3.txt")), (Object)((byte[])ArgumentMatchers.eq((Object)"Recorded body content".getBytes(StandardCharsets.UTF_8))));
    }

    @Test
    public void multipartRequestProcessing() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withMethod(RequestMethod.POST).withHeader("Content-Type", "multipart/form-data").withUrl("/multipart/content").withMultiparts(Arrays.asList(StubMappingJsonRecorderTest.createPart("binaryFile", "This a file content".getBytes(), "application/octet-stream", "binaryFile.raw", new String[0]), StubMappingJsonRecorderTest.createPart("textFile", "This a file content".getBytes(), "text/plain", "textFile.txt", new String[0]), StubMappingJsonRecorderTest.createPart("formInput", "I am a field!".getBytes(), null, null, new String[0]))).build();
        this.listener.requestReceived(request, Response.response().status(200).body("anything").fromProxy(true).build());
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.eq((Object)"mapping-multipart-content-1$2!3.json")), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.equalToBinaryJson(MULTIPART_REQUEST_MAPPING, JSONCompareMode.STRICT_ORDER))));
    }

    @Test
    public void multipartRequestProcessingWithNonFileMultipart() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withMethod(RequestMethod.POST).withHeader("Content-Type", "multipart/form-data; boundary=aBoundary").withUrl("/multipart/content").withBody("--aBoundary\r\nContent").withMultiparts(null).build();
        ((Request)Mockito.doReturn((Object)true).when((Object)request)).isMultipart();
        this.listener.requestReceived(request, Response.response().status(200).body("anything").fromProxy(true).build());
        ((BlobStore)Mockito.verify((Object)this.mappingsBlobStore)).put((Object)((String)ArgumentMatchers.eq((Object)"mapping-multipart-content-1$2!3.json")), (Object)((byte[])MockitoHamcrest.argThat(WireMatchers.bytesEqualToJson(BAD_MULTIPART_REQUEST_MAPPING, JSONCompareMode.STRICT_ORDER))));
    }

    @Test
    public void detectsJsonExtensionFromFileExtension() {
        this.assertResultingFileExtension("/my/file.json", "json");
    }

    @Test
    public void detectsGifExtensionFromFileExtension() {
        this.assertResultingFileExtension("/my/file.gif", "gif");
    }

    @Test
    public void detectsXmlExtensionFromResponseContentTypeHeader() {
        this.assertResultingFileExtension("/noext", "xml", "application/xml");
    }

    @Test
    public void detectsJsonExtensionFromResponseContentTypeHeader() {
        this.assertResultingFileExtension("/noext", "json", "application/json");
    }

    @Test
    public void detectsJsonExtensionFromCustomResponseContentTypeHeader() {
        this.assertResultingFileExtension("/noext", "json", "application/vnd.api+json");
    }

    @Test
    public void detectsJpegExtensionFromResponseContentTypeHeader() {
        this.assertResultingFileExtension("/noext", "jpeg", "image/jpeg");
    }

    @Test
    public void detectsIcoExtensionFromResponseContentTypeHeader() {
        this.assertResultingFileExtension("/noext", "ico", "image/x-icon");
    }

    @Test
    public void sanitisesFilenamesBySwappingSymbolsForUnderscores() {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withMethod(RequestMethod.GET).withUrl("/my:oddly;~named!file/url").build();
        Response.Builder responseBuilder = Response.response().status(200).fromProxy(true);
        Response response = responseBuilder.build();
        this.listener.requestReceived(request, response);
        ((BlobStore)Mockito.verify((Object)this.filesBlobStore)).put((Object)((String)MockitoHamcrest.argThat((Matcher)Matchers.containsString((String)"body-my_oddly__named_file-url"))), (Object)((byte[])ArgumentMatchers.any(byte[].class)));
    }

    private void assertResultingFileExtension(String url, String expectedExension) {
        this.assertResultingFileExtension(url, expectedExension, null);
    }

    private void assertResultingFileExtension(String url, String expectedExension, String contentTypeHeader) {
        Mockito.when((Object)this.admin.countRequestsMatching((RequestPattern)ArgumentMatchers.any(RequestPattern.class))).thenReturn((Object)VerificationResult.withCount((int)0));
        Request request = new MockRequestBuilder().withMethod(RequestMethod.GET).withUrl(url).build();
        byte[] body = new byte[]{1};
        Response.Builder responseBuilder = Response.response().status(200).fromProxy(true).body(body);
        if (contentTypeHeader != null) {
            responseBuilder.headers(new HttpHeaders(new HttpHeader[]{HttpHeader.httpHeader((String)"Content-Type", (String[])new String[]{contentTypeHeader})}));
        }
        Response response = responseBuilder.build();
        this.listener.requestReceived(request, response);
        ((BlobStore)Mockito.verify((Object)this.filesBlobStore)).put((Object)((String)MockitoHamcrest.argThat((Matcher)Matchers.endsWith((String)("." + expectedExension)))), (Object)((byte[])ArgumentMatchers.any(byte[].class)));
    }

    private IdGenerator fixedIdGenerator(String id) {
        return () -> id;
    }

    private static Request.Part createPart(String name, byte[] data, String contentType, String fileName, String ... extraHeaderLines) {
        MockMultipart part = new MockMultipart().name(name).body(data);
        for (String headerLine : extraHeaderLines) {
            int end;
            int i = headerLine.indexOf(58);
            if (i <= 0) {
                Assertions.fail((String)("Invalid header expected line: " + headerLine));
            }
            ArrayList<String> params = new ArrayList<String>();
            int start = i + 1;
            while ((end = headerLine.indexOf(59, start)) > 0) {
                params.add(headerLine.substring(start, end).trim());
                start = end + 1;
            }
            part.header(headerLine.substring(0, i).trim(), params.toArray(new String[0]));
        }
        if (contentType != null) {
            part.header("Content-Type", contentType);
        }
        if (fileName == null) {
            part.header("Content-Disposition", "form-data", "name=\"" + name + "\"");
        } else {
            part.header("Content-Disposition", "form-data", "name=\"" + name + "\"", "filename=\"" + fileName + "\"");
        }
        return part;
    }
}

