/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class StubMappingTest {
    @Test
    public void excludesInsertionIndexFromPublicView() {
        StubMapping stub = WireMock.get((String)"/saveable").willReturn(WireMock.ok()).build();
        String json = Json.write((Object)stub);
        System.out.println(json);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"insertionIndex")));
    }

    @Test
    public void includedInsertionIndexInPrivateView() {
        StubMapping stub = WireMock.get((String)"/saveable").willReturn(WireMock.ok()).build();
        String json = Json.writePrivate((Object)stub);
        System.out.println(json);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"insertionIndex"));
    }

    @Test
    public void deserialisesInsertionIndex() {
        String json = "{\n    \"request\": {\n        \"method\": \"ANY\",\n        \"url\": \"/\"\n    },\n    \"response\": {\n        \"status\": 200\n    },\n    \"insertionIndex\": 42\n}";
        StubMapping stub = (StubMapping)Json.read((String)json, StubMapping.class);
        MatcherAssert.assertThat((Object)stub.getInsertionIndex(), (Matcher)Matchers.is((Object)42L));
    }
}

