/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.testsupport;

import com.github.jknack.handlebars.Helper;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionFactory;
import com.github.tomakehurst.wiremock.extension.WireMockServices;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformerTest;
import com.github.tomakehurst.wiremock.testsupport.MockWireMockServices;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ExtensionFactoryUtils {
    public static ResponseTemplateTransformer buildTemplateTransformer(boolean global) {
        return (ResponseTemplateTransformer)ExtensionFactoryUtils.buildExtension(new MockWireMockServices(), services -> List.of(new ResponseTemplateTransformer(services.getTemplateEngine(), global, services.getFiles(), Collections.emptyList())));
    }

    public static ResponseTemplateTransformer buildTemplateTransformer(boolean global, String helperName, Helper<?> helper) {
        return (ResponseTemplateTransformer)ExtensionFactoryUtils.buildExtension(new MockWireMockServices().setHelpers(Map.of(helperName, helper)), services -> List.of(new ResponseTemplateTransformer(services.getTemplateEngine(), global, services.getFiles(), Collections.emptyList())));
    }

    public static ResponseTemplateTransformer buildTemplateTransformer(Long maxCacheEntries) {
        return (ResponseTemplateTransformer)ExtensionFactoryUtils.buildExtension(new MockWireMockServices().setMaxCacheEntries(maxCacheEntries), services -> List.of(new ResponseTemplateTransformer(services.getTemplateEngine(), false, services.getFiles(), Collections.emptyList())));
    }

    public static Extension buildExtension(MockWireMockServices wireMockServices, ExtensionFactory factory) {
        ClasspathFileSource fileSource = new ClasspathFileSource(ResponseTemplateTransformerTest.class.getClassLoader().getResource("templates").getPath());
        wireMockServices.setFileSource((FileSource)fileSource);
        return (Extension)factory.create((WireMockServices)wireMockServices).stream().findFirst().get();
    }
}

