/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.MockRequestBuilder;
import com.github.tomakehurst.wiremock.verification.InMemoryRequestJournal;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InMemoryRequestJournalTest {
    static final Map<String, RequestMatcherExtension> NO_CUSTOM_MATCHERS = Collections.emptyMap();
    private ServeEvent serveEvent1;
    private ServeEvent serveEvent2;
    private ServeEvent serveEvent3;

    @BeforeEach
    public void createTestRequests() {
        this.serveEvent1 = ServeEvent.of((Request)LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest("log1").withUrl("/logging1").build()));
        this.serveEvent2 = ServeEvent.of((Request)LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest("log2").withUrl("/logging2").build()));
        this.serveEvent3 = ServeEvent.of((Request)LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest("log3").withUrl("/logging3").build()));
    }

    @Test
    public void returnsAllLoggedRequestsWhenNoJournalSizeLimit() {
        InMemoryRequestJournal journal = new InMemoryRequestJournal(null, NO_CUSTOM_MATCHERS);
        journal.requestReceived(this.serveEvent1);
        journal.requestReceived(this.serveEvent1);
        journal.requestReceived(this.serveEvent2);
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging1")).build()), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging2")).build()), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void resettingTheJournalClearsAllEntries() throws Exception {
        LoggedRequest loggedRequest = LoggedRequest.createFrom((Request)MockRequestBuilder.aRequest().withUrl("/for/logging").build());
        InMemoryRequestJournal journal = new InMemoryRequestJournal(Integer.valueOf(1), NO_CUSTOM_MATCHERS);
        journal.requestReceived(ServeEvent.of((Request)loggedRequest));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(RequestPattern.everything()), (Matcher)Matchers.is((Object)1));
        journal.reset();
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(RequestPattern.everything()), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void discardsOldRequestsWhenJournalSizeIsLimited() throws Exception {
        InMemoryRequestJournal journal = new InMemoryRequestJournal(Integer.valueOf(2), NO_CUSTOM_MATCHERS);
        journal.requestReceived(this.serveEvent1);
        journal.requestReceived(this.serveEvent2);
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(RequestPattern.everything()), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging1")).build()), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging2")).build()), (Matcher)Matchers.is((Object)1));
        journal.requestReceived(this.serveEvent3);
        this.assertOnlyLastTwoRequestsLeft((RequestJournal)journal);
    }

    @Test
    public void matchesRequestWithCustomMatcherDefinition() throws Exception {
        InMemoryRequestJournal journal = new InMemoryRequestJournal(null, Map.of(RequestMatcherExtension.ALWAYS.getName(), RequestMatcherExtension.ALWAYS));
        journal.requestReceived(this.serveEvent1);
        journal.requestReceived(this.serveEvent2);
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.requestMadeFor((String)RequestMatcherExtension.ALWAYS.getName(), (Parameters)Parameters.empty()).build()), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.requestMadeFor((String)"not-existing", (Parameters)Parameters.empty()).build()), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)journal.getRequestsMatching(WireMock.requestMadeFor((String)RequestMatcherExtension.ALWAYS.getName(), (Parameters)Parameters.empty()).build()).size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)journal.getRequestsMatching(WireMock.requestMadeFor((String)"not-existing", (Parameters)Parameters.empty()).build()).size(), (Matcher)Matchers.is((Object)0));
    }

    private void assertOnlyLastTwoRequestsLeft(RequestJournal journal) {
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging1")).build()), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging2")).build()), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)journal.countRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/logging3")).build()), (Matcher)Matchers.is((Object)1));
    }
}

