/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class NearMissTest {
    static final String STUB_MAPPING_EXAMPLE = "{\n  \"request\" : {\n    \"url\" : \"/nearly-missed-me\",\n    \"method\" : \"HEAD\"\n  },\n  \"stubMapping\": {\n    \"request\": {\n      \"url\" : \"/missed-me\",\n      \"method\" : \"GET\"  \n    },\n    \"response\": {\n      \"status\": 200\n    }\n  },\n  \"matchResult\": {\n    \"distance\": 0.5\n  }\n}";
    static final String REQUEST_PATTERN_EXAMPLE = "{\n  \"request\" : {\n    \"url\" : \"/nearly-missed-me\",\n    \"method\" : \"HEAD\"\n  },\n  \"requestPattern\": {\n    \"url\" : \"/missed-me\",\n    \"method\" : \"GET\"\n  },\n  \"matchResult\": {\n    \"distance\": 0.5\n  }\n}";

    @Test
    public void correctlySerialisesToJsonWithStubMapping() {
        String json = Json.write((Object)new NearMiss(LoggedRequest.createFrom((Request)MockRequest.mockRequest().method(RequestMethod.HEAD).url("/nearly-missed-me")), WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/missed-me")).willReturn(WireMock.aResponse()).build(), MatchResult.partialMatch((double)0.5), null));
        MatcherAssert.assertThat((Object)json, WireMatchers.equalToJson(STUB_MAPPING_EXAMPLE, JSONCompareMode.LENIENT));
    }

    @Test
    public void correctlySerialisesToJsonWithRequestPattern() {
        String json = Json.write((Object)new NearMiss(LoggedRequest.createFrom((Request)MockRequest.mockRequest().method(RequestMethod.HEAD).url("/nearly-missed-me")), WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/missed-me")).willReturn(WireMock.aResponse()).build().getRequest(), MatchResult.partialMatch((double)0.5)));
        MatcherAssert.assertThat((Object)json, WireMatchers.equalToJson(REQUEST_PATTERN_EXAMPLE, JSONCompareMode.LENIENT));
    }

    @Test
    public void correctlyDeserialisesFromJsonWithStubMapping() {
        NearMiss nearMiss = (NearMiss)Json.read((String)STUB_MAPPING_EXAMPLE, NearMiss.class);
        MatcherAssert.assertThat((Object)nearMiss.getRequest().getUrl(), (Matcher)Matchers.is((Object)"/nearly-missed-me"));
        MatcherAssert.assertThat((Object)nearMiss.getRequest().getMethod(), (Matcher)Matchers.is((Object)RequestMethod.HEAD));
        MatcherAssert.assertThat((Object)nearMiss.getStubMapping().getRequest().getUrl(), (Matcher)Matchers.is((Object)"/missed-me"));
        MatcherAssert.assertThat((Object)nearMiss.getStubMapping().getRequest().getMethod(), (Matcher)Matchers.is((Object)RequestMethod.GET));
        MatcherAssert.assertThat((Object)nearMiss.getMatchResult().getDistance(), (Matcher)Matchers.is((Object)0.5));
        MatcherAssert.assertThat((Object)nearMiss.getRequestPattern(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)nearMiss.toString(), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void correctlyDeserialisesFromJsonWithRequestPattern() {
        NearMiss nearMiss = (NearMiss)Json.read((String)REQUEST_PATTERN_EXAMPLE, NearMiss.class);
        MatcherAssert.assertThat((Object)nearMiss.getRequest().getUrl(), (Matcher)Matchers.is((Object)"/nearly-missed-me"));
        MatcherAssert.assertThat((Object)nearMiss.getRequest().getMethod(), (Matcher)Matchers.is((Object)RequestMethod.HEAD));
        MatcherAssert.assertThat((Object)nearMiss.getRequestPattern().getUrl(), (Matcher)Matchers.is((Object)"/missed-me"));
        MatcherAssert.assertThat((Object)nearMiss.getRequestPattern().getMethod(), (Matcher)Matchers.is((Object)RequestMethod.GET));
        MatcherAssert.assertThat((Object)nearMiss.getMatchResult().getDistance(), (Matcher)Matchers.is((Object)0.5));
        MatcherAssert.assertThat((Object)nearMiss.getStubMapping(), (Matcher)Matchers.nullValue());
    }
}

