/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.store.RequestJournalStore;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractRequestJournal
implements RequestJournal {
    protected final RequestJournalStore store;
    private final Integer maxEntries;
    private final Map<String, RequestMatcherExtension> customMatchers;

    public AbstractRequestJournal(Integer maxEntries, Map<String, RequestMatcherExtension> customMatchers, RequestJournalStore store) {
        if (maxEntries != null && maxEntries < 0) {
            throw new IllegalArgumentException("Maximum number of entries of journal must be greater than zero");
        }
        this.maxEntries = maxEntries;
        this.customMatchers = customMatchers;
        this.store = store;
    }

    @Override
    public int countRequestsMatching(RequestPattern requestPattern) {
        return (int)this.getRequests().filter(RequestPattern.thatMatch(requestPattern, this.customMatchers)).count();
    }

    @Override
    public List<LoggedRequest> getRequestsMatching(RequestPattern requestPattern) {
        List<LoggedRequest> loggedRequests = this.getRequests().filter(RequestPattern.thatMatch(requestPattern, this.customMatchers)).collect(Collectors.toList());
        Collections.reverse(loggedRequests);
        return loggedRequests;
    }

    @Override
    public void requestReceived(ServeEvent serveEvent) {
        this.store.add(serveEvent);
        this.removeOldEntries();
    }

    @Override
    public void serveCompleted(ServeEvent serveEvent) {
        this.store.put(serveEvent.getId(), serveEvent);
    }

    @Override
    public void removeEvent(UUID eventId) {
        this.store.remove(eventId);
    }

    @Override
    public List<ServeEvent> removeEventsMatching(RequestPattern requestPattern) {
        return this.removeServeEvents(RequestPattern.withRequestMatching(requestPattern));
    }

    @Override
    public List<ServeEvent> removeServeEventsForStubsMatchingMetadata(StringValuePattern metadataPattern) {
        return this.removeServeEvents(AbstractRequestJournal.withStubMetadataMatching(metadataPattern));
    }

    private List<ServeEvent> removeServeEvents(Predicate<ServeEvent> predicate) {
        List<ServeEvent> toDelete = this.store.getAll().filter(predicate).collect(Collectors.toList());
        for (ServeEvent event : toDelete) {
            this.store.remove(event.getId());
        }
        return toDelete;
    }

    @Override
    public List<ServeEvent> getAllServeEvents() {
        return this.store.getAll().collect(Collectors.toList());
    }

    @Override
    public Optional<ServeEvent> getServeEvent(UUID id) {
        return this.store.get(id);
    }

    @Override
    public void reset() {
        this.store.clear();
    }

    private Stream<LoggedRequest> getRequests() {
        return this.store.getAll().map(ServeEvent::getRequest);
    }

    private void removeOldEntries() {
        if (this.maxEntries != null) {
            while (this.store.getAllKeys().count() > (long)this.maxEntries.intValue()) {
                this.store.removeLast();
            }
        }
    }

    private static Predicate<ServeEvent> withStubMetadataMatching(StringValuePattern metadataPattern) {
        return serveEvent -> {
            StubMapping stub = serveEvent.getStubMapping();
            if (stub != null) {
                String metadataJson = Json.write(stub.getMetadata());
                return metadataPattern.match(metadataJson).isExactMatch();
            }
            return false;
        };
    }
}

