/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Gzip {
    private Gzip() {
    }

    public static byte[] unGzip(byte[] gzippedContent) {
        if (gzippedContent.length == 0) {
            return new byte[0];
        }
        try {
            GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(gzippedContent));
            return gzipInputStream.readAllBytes();
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, byte[].class);
        }
    }

    public static String unGzipToString(byte[] gzippedContent) {
        return new String(Gzip.unGzip(gzippedContent));
    }

    public static byte[] gzip(String plainContent) {
        return Gzip.gzip(plainContent, Strings.DEFAULT_CHARSET);
    }

    public static byte[] gzip(String plainContent, Charset charset) {
        return Gzip.gzip(Strings.bytesFromString(plainContent, charset));
    }

    public static byte[] gzip(byte[] plainContent) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
            gzipOutputStream.write(plainContent);
            gzipOutputStream.close();
            return bytes.toByteArray();
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, byte[].class);
        }
    }

    public static boolean isGzipped(byte[] content) {
        return content.length >= 2 && content[0] == 31 && content[1] == -117;
    }
}

