/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.xml;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.SilentErrorHandler;
import com.github.tomakehurst.wiremock.common.xml.XmlDocument;
import com.github.tomakehurst.wiremock.common.xml.XmlException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import wiremock.org.custommonkey.xmlunit.XMLUnit;

public class Xml {
    public static final DocumentBuilderFactory DEFAULT_DOCUMENT_BUILDER_FACTORY = new DelegateDocumentBuilderFactory(Xml.newDocumentBuilderFactory()){
        private final DocumentBuilder documentBuilder;
        {
            DocumentBuilder db;
            try {
                db = this.delegate.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                db = Exceptions.throwUnchecked(e, DocumentBuilder.class);
            }
            this.documentBuilder = db;
        }

        @Override
        public DocumentBuilder newDocumentBuilder() {
            return this.documentBuilder;
        }
    };

    private Xml() {
    }

    public static void optimizeFactoriesLoading() {
        try {
            String transformerFactoryImpl = TransformerFactory.newInstance().getClass().getName();
            String xPathFactoryImpl = XPathFactory.newInstance().getClass().getName();
            System.setProperty(TransformerFactory.class.getName(), transformerFactoryImpl);
            System.setProperty("javax.xml.xpath.XPathFactory:http://java.sun.com/jaxp/xpath/dom", xPathFactoryImpl);
            XMLUnit.setTransformerFactory(transformerFactoryImpl);
            XMLUnit.setXPathFactory(xPathFactoryImpl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String prettyPrint(String xml) {
        try {
            return Xml.prettyPrint(Xml.read(xml));
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    public static String prettyPrint(Document doc) {
        try {
            TransformerFactory transformerFactory = Xml.createTransformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private static TransformerFactory createTransformerFactory() {
        TransformerFactory transformerFactory;
        try {
            transformerFactory = (TransformerFactory)Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            transformerFactory = TransformerFactory.newInstance();
        }
        transformerFactory.setAttribute("indent-number", 2);
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory;
    }

    public static Document read(String xml) {
        return Xml.read(xml, DEFAULT_DOCUMENT_BUILDER_FACTORY);
    }

    public static Document read(String xml, DocumentBuilderFactory dbf) {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            return db.parse(is);
        }
        catch (SAXException e) {
            throw XmlException.fromSaxException(e);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, Document.class);
        }
    }

    public static XmlDocument parse(String xml) {
        return Xml.parse(xml, Xml.getDocumentBuilder());
    }

    public static XmlDocument parse(String xml, DocumentBuilder db) {
        try {
            InputSource source = new InputSource(new StringReader(xml));
            return new XmlDocument(db.parse(source));
        }
        catch (IOException | SAXException e) {
            throw new XmlException(Errors.single(50, e.getMessage()));
        }
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DEFAULT_DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return Exceptions.throwUnchecked(e, DocumentBuilder.class);
        }
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        try {
            SilentErrorDocumentBuilderFactory dbf = new SilentErrorDocumentBuilderFactory(new SkipResolvingEntitiesDocumentBuilderFactory(DocumentBuilderFactory.newInstance()));
            ((DocumentBuilderFactory)dbf).setFeature("http://xml.org/sax/features/validation", false);
            ((DocumentBuilderFactory)dbf).setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            ((DocumentBuilderFactory)dbf).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            ((DocumentBuilderFactory)dbf).setFeature("http://xml.org/sax/features/external-general-entities", false);
            ((DocumentBuilderFactory)dbf).setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            ((DocumentBuilderFactory)dbf).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return dbf;
        }
        catch (ParserConfigurationException e) {
            return Exceptions.throwUnchecked(e, DocumentBuilderFactory.class);
        }
    }

    private static abstract class DelegateDocumentBuilderFactory
    extends DocumentBuilderFactory {
        protected final DocumentBuilderFactory delegate;

        public DelegateDocumentBuilderFactory(DocumentBuilderFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setAttribute(String name, Object value) throws IllegalArgumentException {
            this.delegate.setAttribute(name, value);
        }

        @Override
        public Object getAttribute(String name) throws IllegalArgumentException {
            return this.delegate.getAttribute(name);
        }

        @Override
        public void setFeature(String name, boolean value) throws ParserConfigurationException {
            this.delegate.setFeature(name, value);
        }

        @Override
        public boolean getFeature(String name) throws ParserConfigurationException {
            return this.delegate.getFeature(name);
        }
    }

    private static class SilentErrorDocumentBuilderFactory
    extends DelegateDocumentBuilderFactory {
        public SilentErrorDocumentBuilderFactory(DocumentBuilderFactory delegate) {
            super(delegate);
        }

        @Override
        public DocumentBuilder newDocumentBuilder() {
            try {
                DocumentBuilder documentBuilder = this.delegate.newDocumentBuilder();
                documentBuilder.setErrorHandler(new SilentErrorHandler());
                return documentBuilder;
            }
            catch (ParserConfigurationException e) {
                return Exceptions.throwUnchecked(e, DocumentBuilder.class);
            }
        }
    }

    private static class SkipResolvingEntitiesDocumentBuilderFactory
    extends DelegateDocumentBuilderFactory {
        public SkipResolvingEntitiesDocumentBuilderFactory(DocumentBuilderFactory delegate) {
            super(delegate);
        }

        @Override
        public DocumentBuilder newDocumentBuilder() {
            try {
                DocumentBuilder documentBuilder = this.delegate.newDocumentBuilder();
                documentBuilder.setEntityResolver(new ResolveToEmptyString());
                return documentBuilder;
            }
            catch (ParserConfigurationException e) {
                return Exceptions.throwUnchecked(e, DocumentBuilder.class);
            }
        }

        private static class ResolveToEmptyString
        implements EntityResolver {
            private ResolveToEmptyString() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        }
    }
}

