/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import com.github.tomakehurst.wiremock.common.JettySettings;
import wiremock.org.eclipse.jetty.http.UriCompliance;
import wiremock.org.eclipse.jetty.io.NetworkTrafficListener;
import wiremock.org.eclipse.jetty.server.ConnectionFactory;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.NetworkTrafficServerConnector;
import wiremock.org.eclipse.jetty.server.SecureRequestCustomizer;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.ServerConnector;

public class Jetty11Utils {
    private static final int DEFAULT_ACCEPTORS = 3;
    private static final int DEFAULT_HEADER_SIZE = 32768;

    private Jetty11Utils() {
    }

    public static ServerConnector createServerConnector(Server jettyServer, String bindAddress, JettySettings jettySettings, int port, NetworkTrafficListener listener, ConnectionFactory ... connectionFactories) {
        int acceptors = jettySettings.getAcceptors().orElse(3);
        NetworkTrafficServerConnector connector = new NetworkTrafficServerConnector(jettyServer, null, null, null, acceptors, 2, connectionFactories);
        connector.setPort(port);
        connector.setNetworkTrafficListener(listener);
        Jetty11Utils.setJettySettings(jettySettings, connector);
        connector.setHost(bindAddress);
        return connector;
    }

    public static void setJettySettings(JettySettings jettySettings, ServerConnector connector) {
        jettySettings.getAcceptQueueSize().ifPresent(connector::setAcceptQueueSize);
        jettySettings.getIdleTimeout().ifPresent(connector::setIdleTimeout);
        connector.setShutdownIdleTimeout(jettySettings.getShutdownIdleTimeout().orElse(200L));
    }

    public static HttpConfiguration createHttpConfig(JettySettings jettySettings) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(jettySettings.getRequestHeaderSize().orElse(32768));
        httpConfig.setResponseHeaderSize(jettySettings.getResponseHeaderSize().orElse(32768));
        httpConfig.setSendDateHeader(false);
        httpConfig.setSendXPoweredBy(false);
        httpConfig.setSendServerVersion(false);
        httpConfig.addCustomizer(new SecureRequestCustomizer(false));
        httpConfig.setUriCompliance(UriCompliance.UNSAFE);
        return httpConfig;
    }
}

