/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.store.ObjectStore;
import com.github.tomakehurst.wiremock.store.StoreEvent;
import com.github.tomakehurst.wiremock.store.StoreEventEmitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class InMemoryObjectStore
implements ObjectStore,
StoreEventEmitter<String, Object> {
    private final ConcurrentHashMap<String, Object> cache;
    private final Queue<String> keyUseOrder = new ConcurrentLinkedQueue<String>();
    private final int maxItems;
    private final List<Consumer<? super StoreEvent<String, Object>>> listeners = new ArrayList<Consumer<? super StoreEvent<String, Object>>>();

    public InMemoryObjectStore(int maxItems) {
        this.cache = new ConcurrentHashMap();
        this.maxItems = maxItems;
    }

    @Override
    public <T> Optional<T> get(String key, Class<T> type) {
        return this.get(key).map(type::cast);
    }

    @Override
    public Optional<Object> get(String key) {
        Optional<Object> value = Optional.ofNullable(this.cache.get(key));
        if (value.isPresent()) {
            this.touch(key);
        }
        return value;
    }

    @Override
    public Stream<String> getAllKeys() {
        return this.cache.keySet().stream();
    }

    @Override
    public void put(String key, Object content) {
        Object previousValue = this.cache.put(key, content);
        this.touchAndResize(key);
        this.handleEvent(StoreEvent.set(key, previousValue, content));
    }

    @Override
    public <T> T compute(String key, Function<T, T> valueFunction) {
        AtomicReference previousValue = new AtomicReference();
        Object result = this.cache.compute(key, (? super K k, ? super V currentValue) -> {
            previousValue.set(currentValue);
            return valueFunction.apply(currentValue);
        });
        if (result != null) {
            this.touchAndResize(key);
        } else {
            this.keyUseOrder.remove(key);
        }
        this.handleEvent(StoreEvent.set(key, previousValue.get(), result));
        return (T)result;
    }

    @Override
    public void remove(String key) {
        Object previousValue = this.cache.remove(key);
        this.keyUseOrder.remove(key);
        if (previousValue != null) {
            this.handleEvent(StoreEvent.remove(key, previousValue));
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.keyUseOrder.clear();
    }

    @Override
    public void registerEventListener(Consumer<? super StoreEvent<String, Object>> handler) {
        this.listeners.add(handler);
    }

    private void handleEvent(StoreEvent<String, Object> event) {
        for (Consumer<? super StoreEvent<String, Object>> listener : this.listeners) {
            try {
                listener.accept(event);
            }
            catch (Exception e) {
                LocalNotifier.notifier().error("Error handling store event", e);
            }
        }
    }

    private void touchAndResize(String key) {
        this.touch(key);
        this.resize();
    }

    private void touch(String key) {
        this.keyUseOrder.remove(key);
        this.keyUseOrder.offer(key);
    }

    private void resize() {
        while (this.keyUseOrder.size() > this.maxItems) {
            String keyToRemove = this.keyUseOrder.poll();
            this.remove(keyToRemove);
        }
    }
}

