/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.DiscriminatorContext;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.TypeFactory;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.utils.SetView;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class AllOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AllOfValidator.class);
    private final List<JsonSchema> schemas;

    public AllOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ALL_OF, validationContext);
        if (!schemaNode.isArray()) {
            JsonType nodeType = TypeFactory.getValueNodeType(schemaNode, this.validationContext.getConfig());
            throw new JsonSchemaException(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(schemaNode)).instanceLocation(schemaLocation.getFragment())).messageKey("type")).arguments(nodeType.toString(), "array")).build());
        }
        int size = schemaNode.size();
        this.schemas = new ArrayList<JsonSchema>(size);
        for (int i = 0; i < size; ++i) {
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i), evaluationPath.append(i), schemaNode.get(i), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        return this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    protected Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean walk) {
        AllOfValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        Set<ValidationMessage> childSchemaErrors = null;
        for (JsonSchema schema : this.schemas) {
            Set<ValidationMessage> localErrors = null;
            localErrors = !walk ? schema.validate(executionContext, node, rootNode, instanceLocation) : schema.walk(executionContext, node, rootNode, instanceLocation, true);
            if (localErrors != null && !localErrors.isEmpty()) {
                if (childSchemaErrors == null) {
                    childSchemaErrors = new SetView<ValidationMessage>();
                }
                ((SetView)childSchemaErrors).union(localErrors);
            }
            if (!this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) continue;
            Iterator<JsonNode> arrayElements = this.schemaNode.elements();
            while (arrayElements.hasNext()) {
                ObjectNode discriminator;
                DiscriminatorContext currentDiscriminatorContext;
                ObjectNode allOfEntry = (ObjectNode)arrayElements.next();
                JsonNode $ref = allOfEntry.get("$ref");
                if (null == $ref || null == (currentDiscriminatorContext = executionContext.getCurrentDiscriminatorContext()) || null == (discriminator = currentDiscriminatorContext.getDiscriminatorForPath(allOfEntry.get("$ref").asText()))) continue;
                AllOfValidator.registerAndMergeDiscriminator(currentDiscriminatorContext, discriminator, this.parentSchema, instanceLocation);
                String discriminatorPropertyName = discriminator.get("propertyName").asText();
                JsonNode discriminatorNode = node.get(discriminatorPropertyName);
                String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.textValue();
                JsonSchema jsonSchema = this.parentSchema;
                AllOfValidator.checkDiscriminatorMatch(currentDiscriminatorContext, discriminator, discriminatorPropertyValue, jsonSchema);
            }
        }
        return childSchemaErrors != null ? childSchemaErrors : Collections.emptySet();
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema && node != null) {
            return this.validate(executionContext, node, rootNode, instanceLocation, true);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(executionContext, node, rootNode, instanceLocation, false);
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }
}

