/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.AbstractJsonValidator;
import wiremock.com.networknt.schema.AbstractKeyword;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.Keyword;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;

public class NonValidationKeyword
extends AbstractKeyword {
    private final boolean collectAnnotations;

    public NonValidationKeyword(String keyword) {
        this(keyword, true);
    }

    public NonValidationKeyword(String keyword, boolean collectAnnotations) {
        super(keyword);
        this.collectAnnotations = collectAnnotations;
    }

    @Override
    public JsonValidator newValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) throws JsonSchemaException, Exception {
        return new Validator(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext, this, this.collectAnnotations);
    }

    private static final class Validator
    extends AbstractJsonValidator {
        private final boolean collectAnnotations;

        public Validator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, Keyword keyword, boolean collectAnnotations) {
            super(schemaLocation, evaluationPath, keyword, schemaNode);
            this.collectAnnotations = collectAnnotations;
            String id = validationContext.resolveSchemaId(schemaNode);
            String anchor = validationContext.getMetaSchema().readAnchor(schemaNode);
            String dynamicAnchor = validationContext.getMetaSchema().readDynamicAnchor(schemaNode);
            if (id != null || anchor != null || dynamicAnchor != null) {
                validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
            }
            if ("$defs".equals(keyword.getValue()) || "definitions".equals(keyword.getValue())) {
                Iterator<Map.Entry<String, JsonNode>> field = schemaNode.fields();
                while (field.hasNext()) {
                    Map.Entry<String, JsonNode> property = field.next();
                    SchemaLocation location = schemaLocation.append(property.getKey());
                    JsonSchema schema = validationContext.newSchema(location, evaluationPath.append(property.getKey()), property.getValue(), parentSchema);
                    validationContext.getSchemaReferences().put(location.toString(), schema);
                }
            }
        }

        @Override
        public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
            Object value;
            if (this.collectAnnotations && this.collectAnnotations(executionContext) && (value = this.getAnnotationValue(this.getSchemaNode())) != null) {
                this.putAnnotation(executionContext, annotation -> annotation.instanceLocation(instanceLocation).value(value));
            }
            return Collections.emptySet();
        }

        protected Object getAnnotationValue(JsonNode schemaNode) {
            if (schemaNode.isTextual()) {
                return schemaNode.textValue();
            }
            if (schemaNode.isNumber()) {
                return schemaNode.numberValue();
            }
            if (schemaNode.isObject()) {
                return schemaNode;
            }
            return null;
        }
    }
}

