/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store.files;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.files.BlobStoreBinaryFile;
import com.github.tomakehurst.wiremock.store.files.BlobStoreTextFile;
import com.github.tomakehurst.wiremock.store.files.PathBased;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public class BlobStoreFileSource
implements FileSource {
    private final BlobStore blobStore;

    public BlobStoreFileSource(BlobStore blobStore) {
        this.blobStore = blobStore;
    }

    @Override
    public BinaryFile getBinaryFileNamed(String name) {
        return new BlobStoreBinaryFile(this.blobStore, name);
    }

    @Override
    public TextFile getTextFileNamed(String name) {
        return new BlobStoreTextFile(this.blobStore, name);
    }

    @Override
    public void createIfNecessary() {
    }

    @Override
    public FileSource child(String subDirectoryName) {
        return this;
    }

    @Override
    public String getPath() {
        if (this.blobStore instanceof PathBased) {
            return ((PathBased)((Object)this.blobStore)).getPath();
        }
        return "";
    }

    @Override
    public URI getUri() {
        return null;
    }

    @Override
    public List<TextFile> listFilesRecursively() {
        return this.blobStore.getAllKeys().map(path -> new BlobStoreTextFile(this.blobStore, (String)path)).collect(Collectors.toList());
    }

    @Override
    public void writeTextFile(String name, String contents) {
        this.blobStore.put(name, Strings.bytesFromString(contents));
    }

    @Override
    public void writeBinaryFile(String name, byte[] contents) {
        this.blobStore.put(name, contents);
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void deleteFile(String name) {
        this.blobStore.remove(name);
    }
}

