/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.annotation;

import java.util.Objects;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.Keyword;
import wiremock.com.networknt.schema.SchemaLocation;

public class JsonNodeAnnotation {
    private final String keyword;
    private final JsonNodePath instanceLocation;
    private final SchemaLocation schemaLocation;
    private final JsonNodePath evaluationPath;
    private final Object value;

    public JsonNodeAnnotation(String keyword, JsonNodePath instanceLocation, SchemaLocation schemaLocation, JsonNodePath evaluationPath, Object value) {
        this.keyword = keyword;
        this.instanceLocation = instanceLocation;
        this.schemaLocation = schemaLocation;
        this.evaluationPath = evaluationPath;
        this.value = value;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public JsonNodePath getInstanceLocation() {
        return this.instanceLocation;
    }

    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    public JsonNodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public String toString() {
        return "JsonNodeAnnotation [evaluationPath=" + this.evaluationPath + ", schemaLocation=" + this.schemaLocation + ", instanceLocation=" + this.instanceLocation + ", keyword=" + this.keyword + ", value=" + this.value + "]";
    }

    public int hashCode() {
        return Objects.hash(this.evaluationPath, this.instanceLocation, this.keyword, this.schemaLocation, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonNodeAnnotation other = (JsonNodeAnnotation)obj;
        return Objects.equals(this.evaluationPath, other.evaluationPath) && Objects.equals(this.instanceLocation, other.instanceLocation) && Objects.equals(this.keyword, other.keyword) && Objects.equals(this.schemaLocation, other.schemaLocation) && Objects.equals(this.value, other.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String keyword;
        private JsonNodePath instanceLocation;
        private SchemaLocation schemaLocation;
        private JsonNodePath evaluationPath;
        private Object value;

        public Builder keyword(Keyword keyword) {
            this.keyword = keyword.getValue();
            return this;
        }

        public Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public Builder instanceLocation(JsonNodePath instanceLocation) {
            this.instanceLocation = instanceLocation;
            return this;
        }

        public Builder schemaLocation(SchemaLocation schemaLocation) {
            this.schemaLocation = schemaLocation;
            return this;
        }

        public Builder evaluationPath(JsonNodePath evaluationPath) {
            this.evaluationPath = evaluationPath;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public JsonNodeAnnotation build() {
            return new JsonNodeAnnotation(this.keyword, this.instanceLocation, this.schemaLocation, this.evaluationPath, this.value);
        }
    }
}

