/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.EagerMatchResult;
import com.github.tomakehurst.wiremock.matching.WeightedAggregateMatchResult;
import com.github.tomakehurst.wiremock.matching.WeightedMatchResult;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public abstract class MatchResult
implements Comparable<MatchResult> {
    private final Queue<SubEvent> subEvents;
    public static final Predicate<WeightedMatchResult> ARE_EXACT_MATCH = WeightedMatchResult::isExactMatch;

    public MatchResult() {
        this.subEvents = new LinkedBlockingQueue<SubEvent>();
    }

    public MatchResult(List<SubEvent> subEvents) {
        this.subEvents = new LinkedBlockingQueue<SubEvent>(subEvents);
    }

    protected void appendSubEvent(SubEvent subEvent) {
        this.subEvents.add(subEvent);
    }

    public List<SubEvent> getSubEvents() {
        return new ArrayList<SubEvent>(this.subEvents);
    }

    @JsonCreator
    public static MatchResult partialMatch(@JsonProperty(value="distance") double distance) {
        return MatchResult.partialMatch(distance, List.of());
    }

    public static MatchResult partialMatch(double distance, SubEvent ... subEvents) {
        return MatchResult.partialMatch(distance, List.of(subEvents));
    }

    public static MatchResult partialMatch(double distance, List<SubEvent> subEvents) {
        return new EagerMatchResult(distance, subEvents);
    }

    public static MatchResult exactMatch(SubEvent ... subEvents) {
        return MatchResult.exactMatch(List.of(subEvents));
    }

    public static MatchResult exactMatch(List<SubEvent> subEvents) {
        return new EagerMatchResult(0.0, subEvents);
    }

    public static MatchResult noMatch(SubEvent ... subEvents) {
        return MatchResult.noMatch(List.of(subEvents));
    }

    public static MatchResult noMatch(List<SubEvent> subEvents) {
        return new EagerMatchResult(1.0, subEvents);
    }

    public static MatchResult of(boolean isMatch, SubEvent ... subEvents) {
        return MatchResult.of(isMatch, List.of(subEvents));
    }

    public static MatchResult of(boolean isMatch, List<SubEvent> subEvents) {
        return isMatch ? MatchResult.exactMatch(subEvents) : MatchResult.noMatch(subEvents);
    }

    public static MatchResult aggregate(MatchResult ... matches) {
        return MatchResult.aggregate(Arrays.asList(matches));
    }

    public static MatchResult aggregate(List<MatchResult> matchResults) {
        return MatchResult.aggregateWeighted(matchResults.stream().map(WeightedMatchResult::new).collect(Collectors.toList()));
    }

    public static MatchResult aggregateWeighted(WeightedMatchResult ... matchResults) {
        return MatchResult.aggregateWeighted(Arrays.asList(matchResults));
    }

    public static MatchResult aggregateWeighted(List<WeightedMatchResult> matchResults) {
        return new WeightedAggregateMatchResult(matchResults);
    }

    @JsonIgnore
    public abstract boolean isExactMatch();

    public abstract double getDistance();

    @Override
    public int compareTo(MatchResult other) {
        return Double.compare(other.getDistance(), this.getDistance());
    }
}

