/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.nio;

import java.util.concurrent.Future;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.concurrent.BasicFuture;
import wiremock.org.apache.hc.core5.concurrent.FutureCallback;
import wiremock.org.apache.hc.core5.concurrent.FutureContribution;
import wiremock.org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import wiremock.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import wiremock.org.apache.hc.core5.http.nio.AsyncRequestProducer;
import wiremock.org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import wiremock.org.apache.hc.core5.http.nio.HandlerFactory;
import wiremock.org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.http.protocol.HttpCoreContext;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class AsyncClientEndpoint {
    public abstract void execute(AsyncClientExchangeHandler var1, HandlerFactory<AsyncPushConsumer> var2, HttpContext var3);

    public void execute(AsyncClientExchangeHandler exchangeHandler, HttpContext context) {
        this.execute(exchangeHandler, null, context);
    }

    public abstract void releaseAndReuse();

    public abstract void releaseAndDiscard();

    public abstract boolean isConnected();

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        final BasicFuture<T> future = new BasicFuture<T>(callback);
        this.execute(new BasicClientExchangeHandler<T>(requestProducer, responseConsumer, new FutureContribution<T>(future){

            @Override
            public void completed(T result) {
                future.completed(result);
            }
        }), pushHandlerFactory, context != null ? context : HttpCoreContext.create());
        return future;
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, context, callback);
    }

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, null, callback);
    }
}

