/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wiremock.webhooks.Webhooks;

public class ExtensionDeclarations {
    private final List<String> classNames = new ArrayList<String>();
    private final List<Class<? extends Extension>> classes = new ArrayList<Class<? extends Extension>>();
    private final Map<String, Extension> instances = new LinkedHashMap<String, Extension>();
    private final List<ExtensionFactory> factories = new ArrayList<ExtensionFactory>();
    private static final String WEBHOOK_MESSAGE = "Passing webhooks in extensions is no longer required and may lead to compatibility issues in future";

    public void add(String ... classNames) {
        List processedClassNames = Arrays.stream(classNames).filter(this::removeWebhook).collect(Collectors.toList());
        this.classNames.addAll(processedClassNames);
    }

    public void add(Extension ... extensionInstances) {
        Arrays.stream(extensionInstances).forEach(e -> this.instances.put(e.getName(), (Extension)e));
    }

    public void add(Class<? extends Extension> ... classes) {
        List processedClasses = Arrays.stream(classes).filter(c -> this.removeWebhook(c.getName())).collect(Collectors.toList());
        this.classes.addAll(processedClasses);
    }

    public void add(ExtensionFactory ... factories) {
        this.factories.addAll(Arrays.asList(factories));
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public List<Class<? extends Extension>> getClasses() {
        return this.classes;
    }

    public Map<String, Extension> getInstances() {
        return this.instances;
    }

    public List<ExtensionFactory> getFactories() {
        return this.factories;
    }

    private boolean removeWebhook(String className) {
        if (className.equals(Webhooks.class.getName())) {
            System.out.println(WEBHOOK_MESSAGE);
            return false;
        }
        return true;
    }
}

