/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.store.ObjectStore;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.Stream;

public class InMemoryObjectStore
implements ObjectStore {
    private final ConcurrentHashMap<String, Object> cache;
    private final Queue<String> keyUseOrder = new ConcurrentLinkedQueue<String>();
    private final int maxItems;

    public InMemoryObjectStore(int maxItems) {
        this.cache = new ConcurrentHashMap();
        this.maxItems = maxItems;
    }

    @Override
    public <T> Optional<T> get(String key, Class<T> type) {
        return this.get(key).map(type::cast);
    }

    @Override
    public Optional<Object> get(String key) {
        Optional<Object> value = Optional.ofNullable(this.cache.get(key));
        if (value.isPresent()) {
            this.touch(key);
        }
        return value;
    }

    @Override
    public Stream<String> getAllKeys() {
        return this.cache.keySet().stream();
    }

    @Override
    public void put(String key, Object content) {
        this.cache.put(key, content);
        this.touchAndResize(key);
    }

    @Override
    public <T> T compute(String key, Function<T, T> valueFunction) {
        Object result = this.cache.compute(key, (? super K k, ? super V currentValue) -> valueFunction.apply(currentValue));
        this.touchAndResize(key);
        return (T)result;
    }

    @Override
    public void remove(String key) {
        this.cache.remove(key);
        this.keyUseOrder.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.keyUseOrder.clear();
    }

    private void touchAndResize(String key) {
        this.touch(key);
        this.resize();
    }

    private void touch(String key) {
        this.keyUseOrder.remove(key);
        this.keyUseOrder.offer(key);
    }

    private void resize() {
        while (this.keyUseOrder.size() > this.maxItems) {
            String keyToRemove = this.keyUseOrder.poll();
            this.remove(keyToRemove);
        }
    }
}

