/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.InvalidSchemaException;
import wiremock.com.networknt.schema.JsonMetaSchema;
import wiremock.com.networknt.schema.JsonMetaSchemaFactory;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaFactory;
import wiremock.com.networknt.schema.JsonSchemaVersion;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.SchemaValidatorsConfig;
import wiremock.com.networknt.schema.SpecVersion;
import wiremock.com.networknt.schema.SpecVersionDetector;
import wiremock.com.networknt.schema.ValidationMessage;

public class DefaultJsonMetaSchemaFactory
implements JsonMetaSchemaFactory {
    @Override
    public JsonMetaSchema getMetaSchema(String iri, JsonSchemaFactory schemaFactory, SchemaValidatorsConfig config) {
        return SpecVersionDetector.detectOptionalVersion(iri).map(JsonSchemaFactory::checkVersion).map(JsonSchemaVersion::getInstance).orElseGet(() -> this.loadMetaSchema(iri, schemaFactory, config));
    }

    protected JsonMetaSchema loadMetaSchema(String iri, JsonSchemaFactory schemaFactory, SchemaValidatorsConfig config) {
        try {
            JsonMetaSchema result = this.loadMetaSchemaBuilder(iri, schemaFactory, config).build();
            return result;
        }
        catch (InvalidSchemaException e) {
            throw e;
        }
        catch (Exception e) {
            ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().message("Failed to load meta-schema ''{1}''")).arguments(iri)).build();
            throw new InvalidSchemaException(validationMessage, e);
        }
    }

    protected JsonMetaSchema.Builder loadMetaSchemaBuilder(String iri, JsonSchemaFactory schemaFactory, SchemaValidatorsConfig config) {
        JsonNode vocabulary;
        JsonSchema schema = schemaFactory.getSchema(SchemaLocation.of(iri), config);
        JsonMetaSchema.Builder builder = JsonMetaSchema.builder(iri, schema.getValidationContext().getMetaSchema());
        SpecVersion.VersionFlag specification = schema.getValidationContext().getMetaSchema().getSpecification();
        if (specification != null && specification.getVersionFlagValue() >= SpecVersion.VersionFlag.V201909.getVersionFlagValue() && (vocabulary = schema.getSchemaNode().get("$vocabulary")) != null) {
            builder.vocabularies(vocabularies -> vocabularies.clear());
            for (Map.Entry<String, JsonNode> vocabs : vocabulary.properties()) {
                builder.vocabulary(vocabs.getKey(), vocabs.getValue().booleanValue());
            }
        }
        return builder;
    }

    public static DefaultJsonMetaSchemaFactory getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static DefaultJsonMetaSchemaFactory INSTANCE = new DefaultJsonMetaSchemaFactory();

        private Holder() {
        }
    }
}

