/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Objects;
import wiremock.com.networknt.schema.PathType;

public class JsonNodePath
implements Comparable<JsonNodePath> {
    private final PathType type;
    private final JsonNodePath parent;
    private final String pathSegment;
    private final int pathSegmentIndex;
    private volatile String value = null;

    public JsonNodePath(PathType type) {
        this.type = type;
        this.parent = null;
        this.pathSegment = null;
        this.pathSegmentIndex = -1;
    }

    private JsonNodePath(JsonNodePath parent, String pathSegment) {
        this.parent = parent;
        this.type = parent.type;
        this.pathSegment = pathSegment;
        this.pathSegmentIndex = -1;
    }

    private JsonNodePath(JsonNodePath parent, int pathSegmentIndex) {
        this.parent = parent;
        this.type = parent.type;
        this.pathSegment = null;
        this.pathSegmentIndex = pathSegmentIndex;
    }

    public JsonNodePath getParent() {
        return this.parent;
    }

    public JsonNodePath append(String token) {
        return new JsonNodePath(this, token);
    }

    public JsonNodePath append(int index) {
        return new JsonNodePath(this, index);
    }

    public PathType getPathType() {
        return this.type;
    }

    public String getName(int index) {
        Object element = this.getElement(index);
        if (element != null) {
            return element.toString();
        }
        return null;
    }

    public Object getElement(int index) {
        if (index == -1) {
            if (this.pathSegmentIndex != -1) {
                return this.pathSegmentIndex;
            }
            return this.pathSegment;
        }
        int nameCount = this.getNameCount();
        if (nameCount - 1 == index) {
            return this.getElement(-1);
        }
        int count = nameCount - index - 1;
        if (count < 0) {
            throw new IllegalArgumentException("");
        }
        JsonNodePath current = this;
        for (int x = 0; x < count; ++x) {
            current = current.parent;
        }
        return current.getElement(-1);
    }

    public int getNameCount() {
        int current = this.pathSegmentIndex == -1 && this.pathSegment == null ? 0 : 1;
        int parent = this.parent != null ? this.parent.getNameCount() : 0;
        return current + parent;
    }

    public boolean startsWith(JsonNodePath other) {
        int count = this.getNameCount();
        int otherCount = other.getNameCount();
        if (otherCount > count) {
            return false;
        }
        if (otherCount == count) {
            return this.equals(other);
        }
        JsonNodePath compare = this;
        for (int x = count - otherCount; x > 0; --x) {
            compare = compare.getParent();
        }
        return other.equals(compare);
    }

    public boolean contains(String segment) {
        boolean result = segment.equals(this.pathSegment);
        if (result) {
            return true;
        }
        for (JsonNodePath path = this.getParent(); path != null; path = path.getParent()) {
            if (!segment.equals(path.pathSegment)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.value == null) {
            String parentValue;
            String string = parentValue = this.parent == null ? this.type.getRoot() : this.parent.toString();
            this.value = this.pathSegmentIndex != -1 ? this.type.append(parentValue, this.pathSegmentIndex) : (this.pathSegment != null ? this.type.append(parentValue, this.pathSegment) : parentValue);
        }
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parent, this.pathSegment, this.pathSegmentIndex, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonNodePath other = (JsonNodePath)obj;
        return Objects.equals(this.pathSegment, other.pathSegment) && this.pathSegmentIndex == other.pathSegmentIndex && this.type == other.type && Objects.equals(this.parent, other.parent);
    }

    @Override
    public int compareTo(JsonNodePath other) {
        int result;
        if (this.parent != null && other.parent == null) {
            return 1;
        }
        if (this.parent == null && other.parent != null) {
            return -1;
        }
        if (this.parent != null && other.parent != null && (result = this.parent.compareTo(other.parent)) != 0) {
            return result;
        }
        String thisValue = this.getName(-1);
        String otherValue = other.getName(-1);
        if (thisValue == null && otherValue == null) {
            return 0;
        }
        if (thisValue != null && otherValue == null) {
            return 1;
        }
        if (thisValue == null && otherValue != null) {
            return -1;
        }
        return thisValue.compareTo(otherValue);
    }
}

