/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty12;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.server.handler.ConnectHandler;
import wiremock.org.eclipse.jetty.util.Promise;

public class ManInTheMiddleSslConnectHandler
extends ConnectHandler {
    private final ServerConnector mitmProxyConnector;

    public ManInTheMiddleSslConnectHandler(ServerConnector mitmProxyConnector) {
        this.mitmProxyConnector = mitmProxyConnector;
    }

    @Override
    protected void connectToServer(Request request, String ignoredHost, int ignoredPort, Promise<SocketChannel> promise) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            channel.socket().setTcpNoDelay(true);
            channel.configureBlocking(false);
            String host = ParameterUtils.getFirstNonNull(this.mitmProxyConnector.getHost(), "localhost");
            int port = this.mitmProxyConnector.getLocalPort();
            InetSocketAddress address = this.newConnectAddress(host, port);
            channel.connect(address);
            promise.succeeded(channel);
        }
        catch (Throwable x) {
            this.closeSafely(channel);
            promise.failed(x);
        }
    }

    private void closeSafely(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

