/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import com.github.tomakehurst.wiremock.verification.diff.DiffLine;
import java.util.Map;

public class PlainTextDiffRenderer {
    private final String SEPARATOR = System.lineSeparator();
    private final int consoleWidth;
    private final Map<String, RequestMatcherExtension> customMatcherExtensions;

    public PlainTextDiffRenderer(Map<String, RequestMatcherExtension> customMatcherExtensions) {
        this(customMatcherExtensions, 119);
    }

    public PlainTextDiffRenderer(Map<String, RequestMatcherExtension> customMatcherExtensions, int consoleWidth) {
        this.customMatcherExtensions = customMatcherExtensions;
        this.consoleWidth = consoleWidth;
    }

    public String render(Diff diff) {
        StringBuilder sb = new StringBuilder();
        this.header(sb);
        if (diff.getStubMappingName() != null) {
            this.writeLine(sb, diff.getStubMappingName(), "", null);
            this.writeBlankLine(sb);
        }
        for (DiffLine<?> line : diff.getLines(this.customMatcherExtensions)) {
            boolean isBodyLine = line.getRequestAttribute().equals("Body");
            if (isBodyLine && !line.isForNonMatch()) continue;
            this.writeLine(sb, line.getPrintedPatternValue(), line.getActual().toString(), line.getMessage());
        }
        this.writeBlankLine(sb);
        this.footer(sb);
        return sb.toString();
    }

    private void header(StringBuilder sb) {
        String titleLine = "Request was not matched";
        int middle = this.getMiddle();
        int titleLinePaddingLeft = middle - titleLine.length() / 2;
        sb.append(this.SEPARATOR).append(String.valueOf(' ').repeat(titleLinePaddingLeft)).append(titleLine).append(this.SEPARATOR).append(String.valueOf(' ').repeat(titleLinePaddingLeft)).append(String.valueOf('=').repeat(titleLine.length())).append(this.SEPARATOR).append(this.SEPARATOR).append(String.valueOf('-').repeat(this.consoleWidth)).append(this.SEPARATOR).append('|').append(Strings.rightPad(" Closest stub", middle)).append('|').append(Strings.rightPad(" Request", middle, ' ')).append('|').append(this.SEPARATOR).append(String.valueOf('-').repeat(this.consoleWidth)).append(this.SEPARATOR);
        this.writeBlankLine(sb);
    }

    private void footer(StringBuilder sb) {
        sb.append(String.valueOf('-').repeat(this.consoleWidth)).append(this.SEPARATOR);
    }

    private void writeLine(StringBuilder sb, String left, String right, String message) {
        String[] leftLines = this.wrap(Strings.normaliseLineBreaks(left)).split(this.SEPARATOR);
        String[] rightLines = this.wrap(Strings.normaliseLineBreaks(right)).split(this.SEPARATOR);
        int maxLines = Math.max(leftLines.length, rightLines.length);
        this.writeSingleLine(sb, PlainTextDiffRenderer.firstOrEmpty(leftLines), PlainTextDiffRenderer.firstOrEmpty(rightLines), message);
        if (maxLines > 1) {
            for (int i = 1; i < maxLines; ++i) {
                String leftPart = leftLines.length > i ? leftLines[i] : "";
                String rightPart = rightLines.length > i ? rightLines[i] : "";
                this.writeSingleLine(sb, leftPart, rightPart, null);
            }
        }
    }

    private static String firstOrEmpty(String[] lines) {
        return lines.length > 0 ? lines[0] : "";
    }

    private void writeBlankLine(StringBuilder sb) {
        this.writeSingleLine(sb, "", null, null);
    }

    private void writeSingleLine(StringBuilder sb, String left, String right, String message) {
        sb.append("").append(Strings.rightPad(left, this.getMiddle() + 1, " ")).append("|");
        if (Strings.isNotEmpty(right)) {
            sb.append(" ");
            if (Strings.isNotEmpty(message)) {
                sb.append(Strings.rightPad(right, this.getMiddle() - 6, " ")).append("<<<<< ").append(message);
            } else {
                sb.append(right);
            }
        } else if (Strings.isNotEmpty(message)) {
            sb.append(Strings.rightPad(right, this.getMiddle() - 5, " ")).append("<<<<< ").append(message);
        }
        sb.append(this.SEPARATOR);
    }

    private String wrap(String s) {
        String safeString = s == null ? "" : s;
        return Strings.wrapIfLongestLineExceedsLimit(safeString, this.getColumnWidth());
    }

    private int getColumnWidth() {
        return this.consoleWidth / 2 - 2;
    }

    private int getMiddle() {
        return this.consoleWidth / 2 - 1;
    }
}

