/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Index;
import wiremock.org.eclipse.jetty.util.URIUtil;

public enum HttpScheme {
    HTTP("http"),
    HTTPS("https"),
    WS("ws"),
    WSS("wss");

    public static final Index<HttpScheme> CACHE;
    private final String _string;
    private final ByteBuffer _buffer;
    private final int _defaultPort;

    private HttpScheme(String s) {
        this._string = s;
        this._buffer = BufferUtil.toBuffer(s);
        this._defaultPort = URIUtil.getDefaultPortForScheme(s);
    }

    public ByteBuffer asByteBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public boolean is(String s) {
        return this._string.equalsIgnoreCase(s);
    }

    public String asString() {
        return this._string;
    }

    public int getDefaultPort() {
        return this._defaultPort;
    }

    public int normalizePort(int port) {
        return port == this._defaultPort ? 0 : port;
    }

    public String toString() {
        return this._string;
    }

    @Deprecated
    public static int getDefaultPort(String scheme) {
        return URIUtil.getDefaultPortForScheme(scheme);
    }

    @Deprecated
    public static int normalizePort(String scheme, int port) {
        return URIUtil.normalizePortForScheme(scheme, port);
    }

    public static boolean isSecure(String scheme) {
        return HTTPS.is(scheme) || WSS.is(scheme);
    }

    static {
        CACHE = new Index.Builder().caseSensitive(false).withAll(HttpScheme.values(), HttpScheme::asString).build();
    }
}

