/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http2.frames.DataFrame;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.generator.HeaderGenerator;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.util.BufferUtil;

public class DataGenerator {
    private final HeaderGenerator headerGenerator;

    public DataGenerator(HeaderGenerator headerGenerator) {
        this.headerGenerator = headerGenerator;
    }

    public int generate(ByteBufferPool.Accumulator accumulator, DataFrame frame, int maxLength) {
        return this.generateData(accumulator, frame.getStreamId(), frame.getByteBuffer(), frame.isEndStream(), maxLength);
    }

    public int generateData(ByteBufferPool.Accumulator accumulator, int streamId, ByteBuffer data, boolean last, int maxLength) {
        int maxFrameSize;
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int dataLength = data.remaining();
        int length = Math.min(dataLength, Math.min(maxFrameSize = this.headerGenerator.getMaxFrameSize(), maxLength));
        if (length == dataLength) {
            this.generateFrame(accumulator, streamId, data, last);
        } else {
            int limit = data.limit();
            int newLimit = data.position() + length;
            data.limit(newLimit);
            ByteBuffer slice = data.slice();
            data.position(newLimit);
            data.limit(limit);
            this.generateFrame(accumulator, streamId, slice, false);
        }
        return 9 + length;
    }

    private void generateFrame(ByteBufferPool.Accumulator accumulator, int streamId, ByteBuffer data, boolean last) {
        int length = data.remaining();
        int flags = 0;
        if (last) {
            flags |= 1;
        }
        RetainableByteBuffer header = this.headerGenerator.generate(FrameType.DATA, 9 + length, length, flags, streamId);
        BufferUtil.flipToFlush(header.getByteBuffer(), 0);
        accumulator.append(header);
        if (data.remaining() > 0) {
            accumulator.append(RetainableByteBuffer.wrap(data));
        }
    }
}

