/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http2.frames.Frame;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.frames.PriorityFrame;
import wiremock.org.eclipse.jetty.http2.generator.FrameGenerator;
import wiremock.org.eclipse.jetty.http2.generator.HeaderGenerator;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.util.BufferUtil;

public class PriorityGenerator
extends FrameGenerator {
    public PriorityGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, Frame frame) {
        PriorityFrame priorityFrame = (PriorityFrame)frame;
        return this.generatePriority(accumulator, priorityFrame.getStreamId(), priorityFrame.getParentStreamId(), priorityFrame.getWeight(), priorityFrame.isExclusive());
    }

    public int generatePriority(ByteBufferPool.Accumulator accumulator, int streamId, int parentStreamId, int weight, boolean exclusive) {
        RetainableByteBuffer header = this.generateHeader(FrameType.PRIORITY, 5, 0, streamId);
        ByteBuffer byteBuffer = header.getByteBuffer();
        this.generatePriorityBody(byteBuffer, streamId, parentStreamId, weight, exclusive);
        BufferUtil.flipToFlush(byteBuffer, 0);
        accumulator.append(header);
        return 14;
    }

    public void generatePriorityBody(ByteBuffer header, int streamId, int parentStreamId, int weight, boolean exclusive) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        if (parentStreamId < 0) {
            throw new IllegalArgumentException("Invalid parent stream id: " + parentStreamId);
        }
        if (parentStreamId == streamId) {
            throw new IllegalArgumentException("Stream " + streamId + " cannot depend on stream " + parentStreamId);
        }
        if (weight < 1 || weight > 256) {
            throw new IllegalArgumentException("Invalid weight: " + weight);
        }
        if (exclusive) {
            parentStreamId |= Integer.MIN_VALUE;
        }
        header.putInt(parentStreamId);
        header.put((byte)(weight - 1));
    }
}

