/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.server;

import java.io.EOFException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import wiremock.org.eclipse.jetty.http2.ErrorCode;
import wiremock.org.eclipse.jetty.http2.HTTP2Cipher;
import wiremock.org.eclipse.jetty.http2.HTTP2Stream;
import wiremock.org.eclipse.jetty.http2.api.Session;
import wiremock.org.eclipse.jetty.http2.api.Stream;
import wiremock.org.eclipse.jetty.http2.api.server.ServerSessionListener;
import wiremock.org.eclipse.jetty.http2.frames.GoAwayFrame;
import wiremock.org.eclipse.jetty.http2.frames.HeadersFrame;
import wiremock.org.eclipse.jetty.http2.frames.PushPromiseFrame;
import wiremock.org.eclipse.jetty.http2.frames.ResetFrame;
import wiremock.org.eclipse.jetty.http2.server.AbstractHTTP2ServerConnectionFactory;
import wiremock.org.eclipse.jetty.http2.server.internal.HTTP2ServerConnection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.EofException;
import wiremock.org.eclipse.jetty.io.QuietException;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.NegotiatingServerConnection;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.eclipse.jetty.util.annotation.Name;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class HTTP2ServerConnectionFactory
extends AbstractHTTP2ServerConnectionFactory
implements NegotiatingServerConnection.CipherDiscriminator {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2ServerConnectionFactory.class);

    public HTTP2ServerConnectionFactory() {
        this(new HttpConfiguration());
    }

    public HTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        super(httpConfiguration);
    }

    public HTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(httpConfiguration, protocols);
    }

    @Override
    protected ServerSessionListener newSessionListener(Connector connector, EndPoint endPoint) {
        return new HTTPServerSessionListener(endPoint);
    }

    @Override
    public boolean isAcceptable(String protocol, String tlsProtocol, String tlsCipher) {
        boolean acceptable;
        boolean bl = acceptable = "h2-14".equals(protocol) || !HTTP2Cipher.isBlackListProtocol(tlsProtocol) || !HTTP2Cipher.isBlackListCipher(tlsCipher);
        if (LOG.isDebugEnabled()) {
            LOG.debug("proto={} tls={} cipher={} 9.2.2-acceptable={}", protocol, tlsProtocol, tlsCipher, acceptable);
        }
        return acceptable;
    }

    protected class HTTPServerSessionListener
    implements ServerSessionListener,
    Stream.Listener {
        private final EndPoint endPoint;

        public HTTPServerSessionListener(EndPoint endPoint) {
            this.endPoint = endPoint;
        }

        private HTTP2ServerConnection getConnection() {
            return (HTTP2ServerConnection)this.endPoint.getConnection();
        }

        @Override
        public Map<Integer, Integer> onPreface(Session session) {
            return HTTP2ServerConnectionFactory.this.newSettings();
        }

        @Override
        public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
            this.getConnection().onNewStream((HTTP2Stream)stream, frame);
            return this;
        }

        @Override
        public boolean onIdleTimeout(Session session) {
            long idleTimeout = this.getConnection().getEndPoint().getIdleTimeout();
            return this.getConnection().onSessionTimeout(new TimeoutException("Session idle timeout " + idleTimeout + " ms"));
        }

        @Override
        public void onClose(Session session, GoAwayFrame frame, Callback callback) {
            Object reason = frame.tryConvertPayload();
            if (!StringUtil.isEmpty((String)reason)) {
                reason = " (" + (String)reason + ")";
            }
            EofException failure = new EofException(String.format("Close %s/%s", ErrorCode.toString(frame.getError(), null), reason));
            this.onFailure(session, (Throwable)failure, callback);
        }

        @Override
        public void onFailure(Session session, Throwable failure, Callback callback) {
            this.getConnection().onSessionFailure(failure, callback);
        }

        @Override
        public void onHeaders(Stream stream, HeadersFrame frame) {
            if (frame.isEndStream()) {
                this.getConnection().onTrailers(stream, frame);
            } else {
                this.close(stream, "invalid_trailers");
            }
        }

        @Override
        public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
            this.close(stream, "push_promise");
            return null;
        }

        @Override
        public void onDataAvailable(Stream stream) {
            this.getConnection().onDataAvailable(stream);
        }

        @Override
        public void onReset(Stream stream, ResetFrame frame, Callback callback) {
            EOFException failure = new EOFException("Reset " + ErrorCode.toString(frame.getError(), null));
            this.onFailure(stream, (Throwable)failure, callback);
        }

        @Override
        public void onFailure(Stream stream, int error, String reason, Throwable failure, Callback callback) {
            if (!(failure instanceof QuietException)) {
                failure = new EofException(failure);
            }
            this.onFailure(stream, failure, callback);
        }

        private void onFailure(Stream stream, Throwable failure, Callback callback) {
            this.getConnection().onStreamFailure(stream, failure, callback);
        }

        @Override
        public void onIdleTimeout(Stream stream, TimeoutException x, Promise<Boolean> promise) {
            this.getConnection().onStreamTimeout(stream, x, promise);
        }

        private void close(Stream stream, String reason) {
            stream.getSession().close(ErrorCode.PROTOCOL_ERROR.code, reason, Callback.NOOP);
        }
    }
}

