/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.util.Objects;
import wiremock.org.eclipse.jetty.http.ComplianceViolation;
import wiremock.org.eclipse.jetty.http.HttpVersion;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.server.AbstractConnectionFactory;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.internal.HttpConnection;
import wiremock.org.eclipse.jetty.util.annotation.Name;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class HttpConnectionFactory
extends AbstractConnectionFactory
implements HttpConfiguration.ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectionFactory.class);
    private final HttpConfiguration _config;
    private boolean _useInputDirectByteBuffers;
    private boolean _useOutputDirectByteBuffers;

    public HttpConnectionFactory() {
        this(new HttpConfiguration());
    }

    public HttpConnectionFactory(@Name(value="config") HttpConfiguration config) {
        super(HttpVersion.HTTP_1_1.asString());
        this._config = Objects.requireNonNull(config);
        this.installBean(this._config);
        this.setUseInputDirectByteBuffers(this._config.isUseInputDirectByteBuffers());
        this.setUseOutputDirectByteBuffers(this._config.isUseOutputDirectByteBuffers());
    }

    @Override
    public HttpConfiguration getHttpConfiguration() {
        return this._config;
    }

    @Deprecated(since="12.0.6", forRemoval=true)
    public boolean isRecordHttpComplianceViolations() {
        return !this._config.getComplianceViolationListeners().isEmpty();
    }

    @Deprecated(since="12.0.6", forRemoval=true)
    public void setRecordHttpComplianceViolations(boolean recordHttpComplianceViolations) {
        this._config.addComplianceViolationListener(new ComplianceViolation.LoggingListener());
    }

    public boolean isUseInputDirectByteBuffers() {
        return this._useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this._useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this._useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this._useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        HttpConnection connection = new HttpConnection(this._config, connector, endPoint);
        connection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
        connection.setUseOutputDirectByteBuffers(this.isUseOutputDirectByteBuffers());
        return this.configure(connection, connector, endPoint);
    }
}

