/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.util.Attributes;

public interface Session
extends Attributes {
    public static Session getSession(Object session) {
        if (session instanceof API) {
            API wrapper = (API)session;
            return wrapper.getSession();
        }
        return null;
    }

    public <T extends API> T getApi();

    public boolean isValid();

    public String getId();

    public String getExtendedId();

    public long getLastAccessedTime();

    public void setMaxInactiveInterval(int var1);

    public int getMaxInactiveInterval();

    public void renewId(Request var1, Response var2);

    public void invalidate();

    public boolean isNew() throws IllegalStateException;

    public String encodeURI(Request var1, String var2, boolean var3);

    public static interface API {
        public Session getSession();
    }

    public static interface ValueListener {
        default public void onSessionAttributeUpdate(Session session, String name, Object oldValue, Object newValue) {
        }

        default public void onSessionActivation(Session session) {
        }

        default public void onSessionPassivation(Session session) {
        }
    }

    public static interface LifeCycleListener {
        default public void onSessionIdChanged(Session session, String oldId) {
        }

        default public void onSessionCreated(Session session) {
        }

        default public void onSessionDestroyed(Session session) {
        }
    }
}

