/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.internal;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.PreEncodedHttpField;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ResponseHttpFields
implements HttpFields.Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHttpFields.class);
    private final HttpFields.Mutable _fields = HttpFields.build();
    private final AtomicBoolean _committed = new AtomicBoolean();

    public HttpFields.Mutable getMutableHttpFields() {
        return this._fields;
    }

    public boolean commit() {
        boolean committed = this._committed.compareAndSet(false, true);
        if (committed && LOG.isDebugEnabled()) {
            LOG.debug("{} committed", (Object)this);
        }
        return committed;
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    public void recycle() {
        this._committed.set(false);
        this._fields.clear();
    }

    @Override
    public HttpField getField(String name) {
        return this._fields.getField(name);
    }

    @Override
    public HttpField getField(HttpHeader header) {
        return this._fields.getField(header);
    }

    @Override
    public HttpField getField(int index) {
        return this._fields.getField(index);
    }

    @Override
    public int size() {
        return this._fields.size();
    }

    @Override
    public Stream<HttpField> stream() {
        return this._fields.stream();
    }

    @Override
    public HttpFields.Mutable add(HttpField field) {
        if (field != null && !this._committed.get()) {
            this._fields.add(field);
        }
        return this;
    }

    @Override
    public HttpFields asImmutable() {
        return this._committed.get() ? this : this._fields.asImmutable();
    }

    @Override
    public HttpFields.Mutable clear() {
        if (!this._committed.get()) {
            ListIterator<HttpField> iterator = this._fields.listIterator(this._fields.size());
            while (iterator.hasPrevious()) {
                HttpField field = iterator.previous();
                if (field instanceof Persistent) {
                    Persistent persistent = (Persistent)((Object)field);
                    iterator.set(persistent.getOriginal());
                    continue;
                }
                iterator.remove();
            }
        }
        return this;
    }

    @Override
    public void ensureField(HttpField field) {
        if (!this._committed.get()) {
            this._fields.ensureField(field);
        }
    }

    @Override
    public Iterator<HttpField> iterator() {
        return new Iterator<HttpField>(){
            private final Iterator<HttpField> i;
            private HttpField _current;
            {
                this.i = ResponseHttpFields.this._fields.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public HttpField next() {
                this._current = this.i.next();
                return this._current;
            }

            @Override
            public void remove() {
                if (ResponseHttpFields.this._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                if (Persistent.isPersistent(this._current)) {
                    throw new UnsupportedOperationException("Persistent field");
                }
                if (this._current == null) {
                    throw new IllegalStateException("No current field");
                }
                this.i.remove();
                this._current = null;
            }
        };
    }

    @Override
    public ListIterator<HttpField> listIterator(int index) {
        final ListIterator<HttpField> i = this._fields.listIterator(index);
        return new ListIterator<HttpField>(this){
            private HttpField _current;
            final /* synthetic */ ResponseHttpFields this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public HttpField next() {
                this._current = (HttpField)i.next();
                return this._current;
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public HttpField previous() {
                this._current = (HttpField)i.previous();
                return this._current;
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                if (this.this$0._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                if (Persistent.isPersistent(this._current)) {
                    throw new UnsupportedOperationException("Persistent field");
                }
                if (this._current == null) {
                    throw new IllegalStateException("No current field");
                }
                i.remove();
                this._current = null;
            }

            @Override
            public void set(HttpField field) {
                if (this.this$0._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                HttpField httpField = this._current;
                if (httpField instanceof Persistent) {
                    Persistent persistent = (Persistent)((Object)httpField);
                    if (field == null || !field.isSameName(this._current)) {
                        throw new UnsupportedOperationException("Persistent field");
                    }
                    HttpField httpField2 = field = field instanceof PreEncodedHttpField ? new PersistentPreEncodedHttpField(this._current.getHeader(), field.getValue(), persistent.getOriginal()) : new PersistentHttpField(field, persistent.getOriginal());
                }
                if (this._current == null) {
                    throw new IllegalStateException("No current field");
                }
                if (field == null) {
                    i.remove();
                } else {
                    i.set(field);
                }
                this._current = field;
            }

            @Override
            public void add(HttpField field) {
                if (this.this$0._committed.get()) {
                    throw new UnsupportedOperationException("Read Only");
                }
                if (field != null) {
                    i.add(field);
                }
            }
        };
    }

    public String toString() {
        return this._fields.toString();
    }

    public static interface Persistent {
        public static boolean isPersistent(HttpField field) {
            return field instanceof Persistent;
        }

        public HttpField getOriginal();
    }

    public static class PersistentPreEncodedHttpField
    extends PreEncodedHttpField
    implements Persistent {
        private final HttpField _original;

        public PersistentPreEncodedHttpField(HttpHeader header, String value) {
            this(header, value, (HttpField)null);
        }

        PersistentPreEncodedHttpField(HttpHeader header, String value, HttpField original) {
            super(header, value);
            this._original = original == null ? this : original;
        }

        @Override
        public HttpField getOriginal() {
            return this._original;
        }
    }

    public static class PersistentHttpField
    extends HttpField
    implements Persistent {
        private final HttpField _field;
        private final HttpField _original;

        public PersistentHttpField(HttpField field) {
            this(field, null);
        }

        PersistentHttpField(HttpField field, HttpField original) {
            super(field.getHeader(), field.getName(), field.getValue());
            this._field = field;
            this._original = original == null ? this : original;
        }

        @Override
        public int getIntValue() {
            return this._field.getIntValue();
        }

        @Override
        public long getLongValue() {
            return this._field.getIntValue();
        }

        @Override
        public HttpField getOriginal() {
            return this._original;
        }
    }
}

