/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import wiremock.org.eclipse.jetty.util.Attributes;
import wiremock.org.eclipse.jetty.util.component.ContainerLifeCycle;
import wiremock.org.eclipse.jetty.util.component.Dumpable;
import wiremock.org.eclipse.jetty.util.thread.AutoLock;

public class AttributeContainerMap
extends ContainerLifeCycle
implements Attributes {
    private final AutoLock _lock = new AutoLock();
    private final Map<String, Object> _map = new HashMap<String, Object>();

    @Override
    public Object setAttribute(String name, Object attribute) {
        try (AutoLock l = this._lock.lock();){
            Object old = this._map.put(name, attribute);
            this.updateBean(old, attribute);
            Object object = old;
            return object;
        }
    }

    @Override
    public Object removeAttribute(String name) {
        try (AutoLock l = this._lock.lock();){
            Object removed = this._map.remove(name);
            if (removed != null) {
                this.removeBean(removed);
            }
            Object object = removed;
            return object;
        }
    }

    @Override
    public Object getAttribute(String name) {
        try (AutoLock l = this._lock.lock();){
            Object object = this._map.get(name);
            return object;
        }
    }

    @Override
    public Set<String> getAttributeNameSet() {
        try (AutoLock l = this._lock.lock();){
            Set<String> set = this._map.keySet();
            return set;
        }
    }

    @Override
    public void clearAttributes() {
        try (AutoLock l = this._lock.lock();){
            this._map.clear();
            this.removeBeans();
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObject(out, this);
        Dumpable.dumpMapEntries(out, indent, this._map, true);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{size=%d}", this.getClass().getSimpleName(), this.hashCode(), this._map.size());
    }
}

