/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util.thread;

import java.util.concurrent.Executor;

public interface Invocable {
    public static final Runnable NOOP = () -> {};
    public static final ThreadLocal<Boolean> __nonBlocking = new ThreadLocal();

    public static Task from(InvocationType type, Runnable task) {
        Task t;
        if (task instanceof Task && (t = (Task)task).getInvocationType() == type) {
            return t;
        }
        return new ReadyTask(type, task);
    }

    public static boolean isNonBlockingInvocation() {
        return Boolean.TRUE.equals(__nonBlocking.get());
    }

    public static void invokeNonBlocking(Runnable task) {
        Boolean wasNonBlocking = __nonBlocking.get();
        try {
            __nonBlocking.set(Boolean.TRUE);
            task.run();
        }
        finally {
            __nonBlocking.set(wasNonBlocking);
        }
    }

    public static InvocationType combine(InvocationType it1, InvocationType it2) {
        if (it1 != null && it2 != null) {
            if (it1 == it2) {
                return it1;
            }
            if (it1 == InvocationType.EITHER) {
                return it2;
            }
            if (it2 == InvocationType.EITHER) {
                return it1;
            }
        }
        return InvocationType.BLOCKING;
    }

    public static InvocationType combineTypes(InvocationType ... it) {
        if (it == null || it.length == 0) {
            return InvocationType.BLOCKING;
        }
        InvocationType type = it[0];
        for (int i = 1; i < it.length; ++i) {
            type = Invocable.combine(type, it[i]);
        }
        return type;
    }

    public static InvocationType getInvocationType(Object o) {
        if (o instanceof Invocable) {
            return ((Invocable)o).getInvocationType();
        }
        return InvocationType.BLOCKING;
    }

    default public InvocationType getInvocationType() {
        return InvocationType.BLOCKING;
    }

    public static Runnable combine(Runnable ... runnables) {
        Runnable result = null;
        for (final Runnable runnable : runnables) {
            if (runnable == null) continue;
            if (result == null) {
                result = runnable;
                continue;
            }
            final Runnable first = result;
            result = new Task(){

                @Override
                public void run() {
                    first.run();
                    runnable.run();
                }

                @Override
                public InvocationType getInvocationType() {
                    return Invocable.combine(Invocable.getInvocationType(first), Invocable.getInvocationType(runnable));
                }
            };
        }
        return result;
    }

    public static interface Task
    extends Invocable,
    Runnable {

        public static abstract class Abstract
        implements Task {
            private final InvocationType type;

            public Abstract(InvocationType type) {
                this.type = type;
            }

            @Override
            public InvocationType getInvocationType() {
                return this.type;
            }

            public String toString() {
                return String.format("%s@%x[%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.getInvocationType()});
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum InvocationType {
        BLOCKING{

            @Override
            public void runWithoutBlocking(Runnable task, Executor executor) {
                executor.execute(task);
            }
        }
        ,
        NON_BLOCKING{

            @Override
            public void runWithoutBlocking(Runnable task, Executor ignored) {
                task.run();
            }
        }
        ,
        EITHER{

            @Override
            public void runWithoutBlocking(Runnable task, Executor ignored) {
                Invocable.invokeNonBlocking(task);
            }
        };


        public abstract void runWithoutBlocking(Runnable var1, Executor var2);
    }

    public static class ReadyTask
    extends Task.Abstract {
        private final Runnable task;

        public ReadyTask(InvocationType type, Runnable task) {
            super(type);
            this.task = task;
        }

        public Runnable getTask() {
            return this.task;
        }

        @Override
        public void run() {
            this.task.run();
        }

        @Override
        public String toString() {
            return String.format("%s@%x[%s|%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.getInvocationType(), this.task});
        }
    }

    public static interface Callable
    extends Invocable {
        public void call() throws Exception;
    }
}

